<?php
/*
 * Plugin Name: Remove "Powered by Wordpress"
 * Version: 1.1.0
 * Plugin URI: http://webd.co.uk/remove-powered-by-wp/
 * Description: Removes the Wordpress credit on the default Wordpress theme for those wanting to customise the theme
 * Author: webd.co.uk
 * Author URI: http://webd.co.uk
 * Text Domain: remove-powered-by-wp
 */

wp_enqueue_style('rpbw-css', plugin_dir_url( __FILE__ ) . 'style.css' );

function rpbw_admin_notice() {

    $plugin_data = get_plugin_data(__FILE__);
    if (get_user_meta(get_current_user_id(), 'rpbw-notice-dismissed', true) != $plugin_data['Version']) {

?>

<div class="notice notice-info is-dismissible rpbw-notice">

<p><strong><?php _e('Thank you for using Remove "Powered by Wordpress" plugin', 'remove-powered-by-wp'); ?></strong><br />
<?php _e('Can you spare some change for a poor web developer? Anything you can give will help him survive the winter, feed his children and keep him off the streets. His eyes are dim. he cannot see. He\'s just a poor old man. His legs are grey. His ears are gnarled. His eyes and legs are old and bent. His ears are grizzled ...', 'remove-powered-by-wp'); ?></p>

<form action="https://www.paypal.com/cgi-bin/webscr" method="post" target="_top">
<input type="hidden" name="cmd" value="_s-xclick">
<input type="hidden" name="hosted_button_id" value="UM35HYGBV8826">
<input type="image" src="<?= plugin_dir_url( __FILE__ ); ?>images/feed-now-button.gif" border="0" name="submit" alt="<?php _e('Feed Now', 'remove-powered-by-wp'); ?>" style="margin: 0; padding: 0 0 0.5em 0;">
<img alt="" border="0" src="https://www.paypalobjects.com/en_GB/i/scr/pixel.gif" width="1" height="1">
</form>

</div>

<script>

    jQuery(document).on('click', '.rpbw-notice .notice-dismiss', function() {

	jQuery.ajax( {

	    url: ajaxurl,
	    data: {

		action: 'dismiss_rpbw_notice_handler',
		security: '<?= wp_create_nonce('rpbw-ajax-nonce'); ?>'

	    }

	} )

    } )

</script>

<?php

    }
}
add_action('admin_notices', 'rpbw_admin_notice');

function rpbw_ajax_notice_handler() {

    check_ajax_referer('rpbw-ajax-nonce','security');
    $plugin_data = get_plugin_data(__FILE__);
    update_user_meta(get_current_user_id(), 'rpbw-notice-dismissed', $plugin_data['Version']);

}
add_action('wp_ajax_dismiss_rpbw_notice_handler', 'rpbw_ajax_notice_handler');

function rpbw_load_plugin_textdomain() {
    load_plugin_textdomain('remove-powered-by-wp', FALSE, basename(dirname(__FILE__)) . '/languages/');
}
add_action('plugins_loaded', 'rpbw_load_plugin_textdomain');

?>