<?php
if(is_multisite()){
	$response_key = get_blog_option($blog_id, 'spam_master_status');
	if($response_key == 'VALID' || $response_key == 'MALFUNCTION_1' || $response_key == 'MALFUNCTION_2'){
		add_action( 'woocommerce_process_registration_errors', 'spam_master_validate_woo_extra_validate_fields', 10, 4 );
		function spam_master_validate_woo_extra_validate_fields($errors, $username, $password, $email){
		global $wpdb, $blog_id;
			//Prepare Email
			$blog_threat_email = wp_strip_all_tags($email);
			if(empty($blog_threat_email)){
				$blog_threat_email = "Spam Bot";
			}

			//Remote Ip
			$blog_threat_ip = $_SERVER['REMOTE_ADDR'];

			//Add Tables
			$table_threats = $wpdb->prefix."spam_master_threats";
			$table_keys = $wpdb->prefix."spam_master_keys";
			$table_white = $wpdb->prefix."spam_master_white";

			//First check Alert and Flooding
			$spam_master_alert_level = get_blog_option($blog_id, 'spam_master_alert_level');
			if ($spam_master_alert_level == 'ALERT_2' || $spam_master_alert_level == 'ALERT_3'){
				$spam_master_last_contact =  $wpdb->get_var("SELECT time FROM $table_keys WHERE spamkey = 'Woocommerce' ORDER BY time DESC LIMIT 1");
				$flood_date_plus_2 = date('Y-m-d H:i:s', strtotime($spam_master_last_contact . '+ 3 minute'));
				$flood_date = current_time('mysql');
				if($flood_date_plus_2 >= $flood_date){

					$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Woocommerce', 'spamvalue' => 'Alert 2/3 warning, woocommerce flooding detected from Ip: ' . $blog_threat_ip . ', Email: ' . $blog_threat_email ));

					throw new Exception( __( '<strong>SPAM MASTER</strong>' . get_blog_option($blog_id, 'spam_master_message'),'spam_master'));
					exit();
				}
			}

			//Log System
			$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Firewall', 'spamvalue' => 'Woocommerce Spam Check Triggered. Incoming: '.$blog_threat_ip ));

			//Check White List
			$is_white = $wpdb->get_results(
						$wpdb->prepare( 
										"SELECT white 
										FROM $table_white
										WHERE white = %s OR white = %s", 
										$blog_threat_ip, $blog_threat_email
						));
			if(!empty($is_white)){
				//insert transient
				$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Woocommerce', 'spamvalue' => 'Approved by whitelist and exempt from spam check, Ip: ' . $blog_threat_ip ));
			}
			else{
				//Check Spam Buffer
				$is_buffer_threat = $wpdb->get_results(
									$wpdb->prepare( 
													"SELECT threat 
													FROM $table_threats
													WHERE threat = %s OR threat = %s", 
													$blog_threat_ip, $blog_threat_email
									));
				if(!empty($is_buffer_threat)){
					//insert transient
					$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Woocommerce', 'spamvalue' => 'Blocked by spam buffer, Ip: ' . $blog_threat_ip . ', Email: ' . $blog_threat_email ));
					$blog_prefix = $wpdb->get_blog_prefix($blog_id);
					$count = $wpdb->query("UPDATE {$blog_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
					throw new Exception( __( '<strong>SPAM MASTER</strong>' . get_blog_option($blog_id, 'spam_master_message'),'spam_master'));
				}
				//buffer empty
				else{
					//create data to be posted
					$blog_license_key = get_blog_option($blog_id, 'spam_license_key');
					$blog_threat_type = 'woocommerce';
					$blog_threat_content = 'woocommerce';
					$blog_web_address = get_site_url();
					$address_unclean = $blog_web_address;
					$address = preg_replace('#^https?://#', '', $address_unclean);
					@$blog_server_ip = $_SERVER['SERVER_ADDR'];
					//if empty ip
					if(empty($blog_server_ip) || $blog_server_ip == '0'){
						@$blog_server_ip = 'I '.gethostbyname($_SERVER['SERVER_NAME']);
					}
					$spam_master_learning_post = array(
														'blog_license_key' => $blog_license_key,
														'blog_threat_ip' => $blog_threat_ip,
														'blog_threat_type' => $blog_threat_type,
														'blog_threat_email' => $blog_threat_email,
														'blog_threat_content' => $blog_threat_content,
														'blog_web_adress' => $address,
														'blog_server_ip' => $blog_server_ip
												);										
					$spam_master_leaning_url = 'aHR0cHM6Ly9zcGFtbWFzdGVyLnRlY2hnYXNwLmNvbS93cC1jb250ZW50L3BsdWdpbnMvc3BhbS1tYXN0ZXItYWRtaW5pc3RyYXRvci9pbmNsdWRlcy9sZWFybmluZy9nZXRfbGVhcm5fcmVnLnBocA==';
					$response = wp_remote_post( base64_decode($spam_master_leaning_url), array(
																								'method' => 'POST',
																								'timeout' => 45,
																								'body' => $spam_master_learning_post
																								));
					if ( is_wp_error( $response ) ) {
						$error_message = $response->get_error_message();
						//Log
						$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'System', 'spamvalue' => 'Error: Woocommerce response. '.$error_message ));
						$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Woocommerce', 'spamvalue' => 'Approved with error, Ip: ' . $blog_threat_ip . ', Email: ' . $blog_threat_email ));
						echo "Something went wrong, please get in touch with TechGasp Support: $error_message";
					}
					else{
						$data = json_decode( wp_remote_retrieve_body( $response ), true );
						if(empty($data)){
							$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Woocommerce', 'spamvalue' => 'Approved, Ip: ' . $blog_threat_ip . ', Email: ' . $blog_threat_email ));
						}
						else{
							$spam_threat = $data['threat'];
							//add to buffer	ip and email
							$wpdb->insert( $table_threats, array( 'time' => current_time( 'mysql' ), 'threat' => $blog_threat_ip ));
							$wpdb->insert( $table_threats, array( 'time' => current_time( 'mysql' ), 'threat' => $blog_threat_email ));
							//insert transient
							$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Woocommerce', 'spamvalue' => 'Blocked by online RBL, Ip: ' . $blog_threat_ip . ', Email: ' . $blog_threat_email ));
							$count = $wpdb->query("UPDATE {$blog_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
							throw new Exception( __( '<strong>SPAM MASTER</strong>' . get_blog_option($blog_id, 'spam_master_message'),'spam_master'));
						}
					}
				//end buffer empty
				}
			//white else
			}
		//end func
		return $errors;
		}
	//end valid
	}
//end multi
}
else{
$response_key = get_option('spam_master_status');
	if($response_key == 'VALID' || $response_key == 'MALFUNCTION_1' || $response_key == 'MALFUNCTION_2'){
		add_action( 'woocommerce_process_registration_errors', 'spam_master_validate_woo_extra_validate_fields', 10, 4 );
		function spam_master_validate_woo_extra_validate_fields($errors, $username, $password, $email){
		global $wpdb;
			//Prepare Email
			$blog_threat_email = wp_strip_all_tags($email);
			if(empty($blog_threat_email)){
				$blog_threat_email = "Spam Bot";
			}

			//Remote Ip
			$blog_threat_ip = $_SERVER['REMOTE_ADDR'];

			//Add Tables
			$table_threats = $wpdb->prefix."spam_master_threats";
			$table_keys = $wpdb->prefix."spam_master_keys";
			$table_white = $wpdb->prefix."spam_master_white";

			//First check Alert and Flooding
			$spam_master_alert_level = get_option('spam_master_alert_level');
			if ($spam_master_alert_level == 'ALERT_2' || $spam_master_alert_level == 'ALERT_3'){
				$spam_master_last_contact =  $wpdb->get_var("SELECT time FROM $table_keys WHERE spamkey = 'Woocommerce' ORDER BY time DESC LIMIT 1");
				$flood_date_plus_2 = date('Y-m-d H:i:s', strtotime($spam_master_last_contact . '+ 3 minute'));
				$flood_date = current_time('mysql');
				if($flood_date_plus_2 >= $flood_date){

					$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Woocommerce', 'spamvalue' => 'Alert 2/3 warning, woocommerce flooding detected from Ip: ' . $blog_threat_ip . ', Email: ' . $blog_threat_email ));

					throw new Exception( __( '<strong>SPAM MASTER</strong>' . get_option('spam_master_message'),'spam_master'));
					exit();
				}
			}

			//Log System
			$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Firewall', 'spamvalue' => 'Woocommerce Spam Check Triggered. Incoming: '.$blog_threat_ip ));

			//Check White List
			$is_white = $wpdb->get_results(
						$wpdb->prepare( 
										"SELECT white 
										FROM $table_white
										WHERE white = %s OR white = %s", 
										$blog_threat_ip, $blog_threat_email
						));
			if(!empty($is_white)){
				//insert transient
				$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Woocommerce', 'spamvalue' => 'Approved by whitelist and exempt from spam check, Ip: ' . $blog_threat_ip ));
			}
			else{
				//Check Spam Buffer
				$is_buffer_threat = $wpdb->get_results(
									$wpdb->prepare( 
													"SELECT threat 
													FROM $table_threats
													WHERE threat = %s OR threat = %s", 
													$blog_threat_ip, $blog_threat_email
									));
				if(!empty($is_buffer_threat)){
					//insert transient
					$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Woocommerce', 'spamvalue' => 'Blocked by spam buffer, Ip: ' . $blog_threat_ip . ', Email: ' . $blog_threat_email ));
					$table_prefix = $wpdb->base_prefix;
					$count = $wpdb->query("UPDATE {$table_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
					throw new Exception( __( '<strong>SPAM MASTER</strong>' . get_option('spam_master_message'),'spam_master'));
				}
				//buffer empty
				else{
					//create data to be posted
					$blog_license_key = get_option('spam_license_key');
					$blog_threat_type = 'woocommerce';
					$blog_threat_content = 'woocommerce';
					$blog_web_address = get_site_url();
					$address_unclean = $blog_web_address;
					$address = preg_replace('#^https?://#', '', $address_unclean);
					@$blog_server_ip = $_SERVER['SERVER_ADDR'];
					//if empty ip
					if(empty($blog_server_ip) || $blog_server_ip == '0'){
						@$blog_server_ip = 'I '.gethostbyname($_SERVER['SERVER_NAME']);
					}
					$spam_master_learning_post = array(
														'blog_license_key' => $blog_license_key,
														'blog_threat_ip' => $blog_threat_ip,
														'blog_threat_type' => $blog_threat_type,
														'blog_threat_email' => $blog_threat_email,
														'blog_threat_content' => $blog_threat_content,
														'blog_web_adress' => $address,
														'blog_server_ip' => $blog_server_ip
													);										
					$spam_master_leaning_url = 'aHR0cHM6Ly9zcGFtbWFzdGVyLnRlY2hnYXNwLmNvbS93cC1jb250ZW50L3BsdWdpbnMvc3BhbS1tYXN0ZXItYWRtaW5pc3RyYXRvci9pbmNsdWRlcy9sZWFybmluZy9nZXRfbGVhcm5fcmVnLnBocA==';
					$response = wp_remote_post( base64_decode($spam_master_leaning_url), array(
																								'method' => 'POST',
																								'timeout' => 45,
																								'body' => $spam_master_learning_post
																							));
					if ( is_wp_error( $response ) ) {
						$error_message = $response->get_error_message();
						//Log
						$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'System', 'spamvalue' => 'Error: Woocommerce response. '.$error_message ));
						echo "Something went wrong, please get in touch with TechGasp Support: $error_message";
					}
					else {
						$data = json_decode( wp_remote_retrieve_body( $response ), true );
						if(empty($data)){
							$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Woocommerce', 'spamvalue' => 'Approved, Ip: ' . $blog_threat_ip . ', Email: ' . $blog_threat_email ));
						}
						else{
							$spam_threat = $data['threat'];
							//add to buffer	ip and email
							$wpdb->insert( $table_threats, array( 'time' => current_time( 'mysql' ), 'threat' => $blog_threat_ip ));
							$wpdb->insert( $table_threats, array( 'time' => current_time( 'mysql' ), 'threat' => $blog_threat_email ));
							//insert transient
							$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Woocommerce', 'spamvalue' => 'Blocked by online RBL, Ip: ' . $blog_threat_ip . ', Email: ' . $blog_threat_email ));
							$table_prefix = $wpdb->base_prefix;
							$count = $wpdb->query("UPDATE {$table_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
							throw new Exception( __( '<strong>SPAM MASTER</strong>' . get_option('spam_master_message'),'spam_master'));
						}
					}
				//end buffer empty
				}
			//white else
			}
		//end func
		return $errors;
		}
	//end valid
	}
//end single
}
?>
