<?php
//post data if license status is valid
if(is_multisite()){
$response_key = get_blog_option($blog_id, 'spam_master_status');
$spam_master_comment_strict_on = get_blog_option($blog_id, 'spam_master_comment_strict_on');
}
else{
$response_key = get_option('spam_master_status');
$spam_master_comment_strict_on = get_option('spam_master_comment_strict_on');
}
//Set malfunctions as VALID
if($response_key == 'VALID' || $response_key == 'MALFUNCTION_1' || $response_key == 'MALFUNCTION_2'){
	if($spam_master_comment_strict_on == 'true'){
		add_filter( 'pre_comment_approved', 'spam_master_comment_learning', '99', 2 );
		add_filter( 'pre_trackback_post', 'spam_master_comment_learning', '99', 2 );
		function spam_master_comment_learning($approved, $commentdata){
		global $wpdb, $blog_id;
			//create data to be posted
			if(is_multisite()){
				$blog_license_key = get_blog_option($blog_id, 'spam_license_key');
				$spam_master_blacklist = get_blog_option($blog_id, 'blacklist_keys');
				$spam_master_whitelist = get_blog_option($blog_id, 'spam_master_whitelist');
				$comment_russian_char = get_blog_option($blog_id, 'comment_russian_char');
				$comment_russian_char_set = get_blog_option($blog_id, 'comment_russian_char_set');
				$comment_chinese_char = get_blog_option($blog_id, 'comment_chinese_char');
				$comment_chinese_char_set = get_blog_option($blog_id, 'comment_chinese_char_set');
				$comment_asian_char = get_blog_option($blog_id, 'comment_asian_char');
				$comment_asian_char_set = get_blog_option($blog_id, 'comment_asian_char_set');
				$comment_arabic_char = get_blog_option($blog_id, 'comment_arabic_char');
				$comment_arabic_char_set = get_blog_option($blog_id, 'comment_arabic_char_set');
				$comment_spam_char = get_blog_option($blog_id, 'comment_spam_char');
				$comment_spam_char_set = get_blog_option($blog_id, 'comment_spam_char_set');
				$spam_master_alert_level = get_blog_option($blog_id, 'spam_master_alert_level');
				
			}
			else{
				$blog_license_key = get_option('spam_license_key');
				$spam_master_blacklist = get_option('blacklist_keys');
				$spam_master_whitelist = get_option('spam_master_whitelist');
				$comment_russian_char = get_option('comment_russian_char');
				$comment_russian_char_set = get_option('comment_russian_char_set');
				$comment_chinese_char = get_option('comment_chinese_char');
				$comment_chinese_char_set = get_option('comment_chinese_char_set');
				$comment_asian_char = get_option('comment_asian_char');
				$comment_asian_char_set = get_option('comment_asian_char_set');
				$comment_arabic_char = get_option('comment_arabic_char');
				$comment_arabic_char_set = get_option('comment_arabic_char_set');
				$comment_spam_char = get_option('comment_spam_char');
				$comment_spam_char_set = get_option('comment_spam_char_set');
				$spam_master_alert_level = get_option('spam_master_alert_level');
			}

			//Remote Ip
			$blog_threat_ip = $_SERVER['REMOTE_ADDR'];

			//Comment Email
			$commentdata_author_email = $commentdata['comment_author_email'];
			if(empty($commentdata_author_email)){
				$commentdata_author_email = date("YmdHis").'@'.date("YmdHis").'.com';
			}

			//check Trackback or Comment
			if(is_trackback()){
				@$request_array = 'HTTP_POST_VARS';
				$blog_threat_type = 'trackback';

				$result_comment_author_email = 'trackback_'.date("YmdHis");
				$tb_url = $_POST['url'];
				if(empty($tb_url)){
					$tb_url = 'empty url';
				}
				$title  = $_POST['title'];
				if(empty($title)){
					$title = 'empty title';
				}
				$excerpt = $_POST['excerpt'];
				if(empty($excerpt)){
					$excerpt = 'empty excerpt';
				}
				$join_tbs = 'URL: '.$tb_url.' - NAME: '.$title.' - TITLE: '.$title.' - EXC: '.$excerpt;
				$result_comment_content_trim = substr($join_tbs,0,360);
				$result_comment_content_clean = wp_strip_all_tags(stripslashes_deep($result_comment_content_trim), true);
			}
			else{
				$blog_threat_type = 'comment';
				//stop process if comment ip is the same as server address
				if($blog_threat_ip == $_SERVER['SERVER_ADDR']){
					//insert transient
					$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Comment', 'spamvalue' => 'Blocked because server Ip is the same as comment Ip. Weird!' ));
					return new WP_Error( 'require_valid_comment', __( '<strong>ERROR</strong>: the comment ip is the same as the web server address.' ), 200 );
				}
				$result_comment_author_email = wp_strip_all_tags($commentdata_author_email);
				$result_comment_content_trim = substr($commentdata['comment_content'],0,360);
				$result_comment_content_clean = wp_strip_all_tags(stripslashes_deep($result_comment_content_trim), true);
			}

			//Add Tables
			$table_threats = $wpdb->prefix."spam_master_threats";
			$table_keys = $wpdb->prefix."spam_master_keys";
			$table_white = $wpdb->prefix."spam_master_white";

			//First check Alert and Flooding
			if ($spam_master_alert_level == 'ALERT_2' || $spam_master_alert_level == 'ALERT_3'){
				$spam_master_last_contact =  $wpdb->get_var("SELECT time FROM $table_keys WHERE spamkey = 'Comment' ORDER BY time DESC LIMIT 1");
				$flood_date_plus_2 = date('Y-m-d H:i:s', strtotime($spam_master_last_contact . '+ 3 minute'));
				$flood_date = current_time('mysql');
				if($flood_date_plus_2 >= $flood_date){

					$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Comment', 'spamvalue' => 'Alert 2/3 warning, comment flooding detected from Ip: ' . $blog_threat_ip . ', Email: ' . $result_comment_author_email .  ', Text: ' . $result_comment_content_clean ));

					return new WP_Error( 'require_valid_email', __( '<strong>SPAM MASTER</strong> Flood detected. Please wait a few minutes.' ), 200 );
					exit();
				}
			}

			//Log System
			$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Firewall', 'spamvalue' => 'Comments Spam Check Triggered. Incoming: '.$blog_threat_ip ));

			//Check White List
			$is_white = $wpdb->get_results(
						$wpdb->prepare( 
										"SELECT white 
										FROM $table_white
										WHERE white = %s OR white = %s", 
										$blog_threat_ip, $commentdata_author_email
						));
			if(!empty($is_white)){
				//insert transient
				$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Comment', 'spamvalue' => 'Approved by whitelist and exempt from spam check, Ip: ' . $blog_threat_ip ));
				$approved = '1';
				return $approved;
				exit();
			}

			//exempt admins from check
			if(!function_exists('wp_get_current_user')) {
				include(ABSPATH . "wp-includes/pluggable.php"); 
			}
			if(current_user_can( 'administrator' ) OR current_user_can( 'editor' ) OR current_user_can( 'author' ) OR current_user_can( 'contributor' )){
				//insert transient
				$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Comment', 'spamvalue' => 'Approved by capable user and exempt from spam check, Ip: ' . $blog_threat_ip ));
				$approved = '1';
				return $approved;
				exit();
			}
			else{
				///////////////////////////////////
				//lets do a quick character block//
				///////////////////////////////////
				if ($comment_russian_char == 'true' || $comment_chinese_char == 'true' || $comment_asian_char == 'true' || $comment_arabic_char == 'true' || $comment_spam_char == 'true'){
					if ($comment_russian_char == 'true'){
						$blacklist_russian_char_string = $comment_russian_char_set;
						$blacklist_russian_char_array = explode("\n", $blacklist_russian_char_string);
						$blacklist_russian_char_size = sizeof($blacklist_russian_char_array);
						// Analyse List
						for($i = 0; $i < $blacklist_russian_char_size; $i++){
							$blacklist_russian_char_current = trim($blacklist_russian_char_array[$i]);
							//check buffer
							if(stripos($commentdata['comment_content'], $blacklist_russian_char_current) !== false){
								//add to buffer	ip and email
								$wpdb->insert( $table_threats, array( 'time' => current_time( 'mysql' ), 'threat' => $blog_threat_ip ));
								$wpdb->insert( $table_threats, array( 'time' => current_time( 'mysql' ), 'threat' => $result_comment_author_email ));
								//insert transient
								$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Comment', 'spamvalue' => 'Blocked using Cyrillic Char, ' . $blacklist_russian_char_current . ', Ip: ' . $blog_threat_ip . ', Email: ' . $result_comment_author_email .  ', Text: ' . $result_comment_content_clean ));
								//Report only, create data to be posted
								$blog_web_address = get_site_url();
								$address_unclean = $blog_web_address;
								$address = preg_replace('#^https?://#', '', $address_unclean);
								@$blog_server_ip = $_SERVER['SERVER_ADDR'];
								//if empty ip
								if(empty($blog_server_ip) || $blog_server_ip == '0'){
									@$blog_server_ip = 'I '.gethostbyname($_SERVER['SERVER_NAME']);
								}
								$spam_master_learning_post = array(
																	'blog_license_key' => $blog_license_key,
																	'blog_threat_ip' => $blog_threat_ip,
																	'blog_threat_type' => $blog_threat_type,
																	'blog_threat_email' => $result_comment_author_email,
																	'blog_threat_content' => 'Cyrillic Char: '. $blacklist_russian_char_current . 'Text: ' .$result_comment_content_clean,
																	'blog_web_adress' => $address,
																	'blog_server_ip' => $blog_server_ip
															);										
								$spam_master_leaning_url = 'aHR0cHM6Ly9zcGFtbWFzdGVyLnRlY2hnYXNwLmNvbS93cC1jb250ZW50L3BsdWdpbnMvc3BhbS1tYXN0ZXItYWRtaW5pc3RyYXRvci9pbmNsdWRlcy9sZWFybmluZy9nZXRfbGVhcm5fY29tLnBocA==';
								$response = wp_remote_post( base64_decode($spam_master_leaning_url), array(
																											'method' => 'POST',
																											'timeout' => 45,
																											'body' => $spam_master_learning_post
																											));
								if(is_multisite()){
									$blog_prefix = $wpdb->get_blog_prefix($blog_id);
									$count = $wpdb->query("UPDATE {$blog_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
									$approved = 'spam';
									return new WP_Error( 'require_valid_email', __( '<strong>SPAM MASTER</strong>'. get_blog_option($blog_id, 'spam_master_message').'' ), 200 );
								}
								else{
									$table_prefix = $wpdb->base_prefix;
									$count = $wpdb->query("UPDATE {$table_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
									$approved = 'spam';
									return new WP_Error( 'require_valid_email', __( '<strong>SPAM MASTER</strong>'. get_option('spam_master_message').'' ), 200 );
								}
							return $approved;
							//end stripos
							}
						//end for
						}
					}
					if ($comment_chinese_char == 'true'){
						$blacklist_chinese_char_string = $comment_chinese_char_set;
						$blacklist_chinese_char_array = explode("\n", $blacklist_chinese_char_string);
						$blacklist_chinese_char_size = sizeof($blacklist_chinese_char_array);
						// Analyse List
						for($i = 0; $i < $blacklist_chinese_char_size; $i++){
							$blacklist_chinese_char_current = trim($blacklist_chinese_char_array[$i]);
							//check buffer
							if(stripos($commentdata['comment_content'], $blacklist_chinese_char_current) !== false){
								//add to buffer	ip and email
								$wpdb->insert( $table_threats, array( 'time' => current_time( 'mysql' ), 'threat' => $blog_threat_ip ));
								$wpdb->insert( $table_threats, array( 'time' => current_time( 'mysql' ), 'threat' => $result_comment_author_email ));
								//insert transient
								$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Comment', 'spamvalue' => 'Blocked using Chinese Char, ' . $blacklist_chinese_char_current . ', Ip: ' . $blog_threat_ip . ', Email: ' . $result_comment_author_email .  ', Text: ' . $result_comment_content_clean ));
								//Report only, create data to be posted
								$blog_web_address = get_site_url();
								$address_unclean = $blog_web_address;
								$address = preg_replace('#^https?://#', '', $address_unclean);
								@$blog_server_ip = $_SERVER['SERVER_ADDR'];
								//if empty ip
								if(empty($blog_server_ip) || $blog_server_ip == '0'){
									@$blog_server_ip = 'I '.gethostbyname($_SERVER['SERVER_NAME']);
								}
								$spam_master_learning_post = array(
																	'blog_license_key' => $blog_license_key,
																	'blog_threat_ip' => $blog_threat_ip,
																	'blog_threat_type' => $blog_threat_type,
																	'blog_threat_email' => $result_comment_author_email,
																	'blog_threat_content' => 'Chinese Char: '. $blacklist_chinese_char_current . 'Text: ' .$result_comment_content_clean,
																	'blog_web_adress' => $address,
																	'blog_server_ip' => $blog_server_ip
															);										
								$spam_master_leaning_url = 'aHR0cHM6Ly9zcGFtbWFzdGVyLnRlY2hnYXNwLmNvbS93cC1jb250ZW50L3BsdWdpbnMvc3BhbS1tYXN0ZXItYWRtaW5pc3RyYXRvci9pbmNsdWRlcy9sZWFybmluZy9nZXRfbGVhcm5fY29tLnBocA==';
								$response = wp_remote_post( base64_decode($spam_master_leaning_url), array(
																											'method' => 'POST',
																											'timeout' => 45,
																											'body' => $spam_master_learning_post
																											));
								if(is_multisite()){
									$blog_prefix = $wpdb->get_blog_prefix($blog_id);
									$count = $wpdb->query("UPDATE {$blog_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
									$approved = 'spam';
									return new WP_Error( 'require_valid_email', __( '<strong>SPAM MASTER</strong>'. get_blog_option($blog_id, 'spam_master_message').'' ), 200 );
								}
								else{
									$table_prefix = $wpdb->base_prefix;
									$count = $wpdb->query("UPDATE {$table_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
									$approved = 'spam';
									return new WP_Error( 'require_valid_email', __( '<strong>SPAM MASTER</strong>'. get_option('spam_master_message').'' ), 200 );
								}
							return $approved;
							//end stripos
							}
						//end for
						}
					}
					if ($comment_asian_char == 'true'){
						$blacklist_asian_char_string = $comment_asian_char_set;
						$blacklist_asian_char_array = explode("\n", $blacklist_asian_char_string);
						$blacklist_asian_char_size = sizeof($blacklist_asian_char_array);
						// Analyse List
						for($i = 0; $i < $blacklist_asian_char_size; $i++){
							$blacklist_asian_char_current = trim($blacklist_asian_char_array[$i]);
							//check buffer
							if(stripos($commentdata['comment_content'], $blacklist_asian_char_current) !== false){
								//add to buffer	ip and email
								$wpdb->insert( $table_threats, array( 'time' => current_time( 'mysql' ), 'threat' => $blog_threat_ip ));
								$wpdb->insert( $table_threats, array( 'time' => current_time( 'mysql' ), 'threat' => $result_comment_author_email ));
								//insert transient
								$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Comment', 'spamvalue' => 'Blocked using Asian Char, ' . $blacklist_asian_char_current . ', Ip: ' . $blog_threat_ip . ', Email: ' . $result_comment_author_email .  ', Text: ' . $result_comment_content_clean ));
								//Report only, create data to be posted
								$blog_web_address = get_site_url();
								$address_unclean = $blog_web_address;
								$address = preg_replace('#^https?://#', '', $address_unclean);
								@$blog_server_ip = $_SERVER['SERVER_ADDR'];
								//if empty ip
								if(empty($blog_server_ip) || $blog_server_ip == '0'){
									@$blog_server_ip = 'I '.gethostbyname($_SERVER['SERVER_NAME']);
								}
								$spam_master_learning_post = array(
																	'blog_license_key' => $blog_license_key,
																	'blog_threat_ip' => $blog_threat_ip,
																	'blog_threat_type' => $blog_threat_type,
																	'blog_threat_email' => $result_comment_author_email,
																	'blog_threat_content' => 'Asian Char: '. $blacklist_asian_char_current . 'Text: ' .$result_comment_content_clean,
																	'blog_web_adress' => $address,
																	'blog_server_ip' => $blog_server_ip
															);										
								$spam_master_leaning_url = 'aHR0cHM6Ly9zcGFtbWFzdGVyLnRlY2hnYXNwLmNvbS93cC1jb250ZW50L3BsdWdpbnMvc3BhbS1tYXN0ZXItYWRtaW5pc3RyYXRvci9pbmNsdWRlcy9sZWFybmluZy9nZXRfbGVhcm5fY29tLnBocA==';
								$response = wp_remote_post( base64_decode($spam_master_leaning_url), array(
																											'method' => 'POST',
																											'timeout' => 45,
																											'body' => $spam_master_learning_post
																											));
								if(is_multisite()){
									$blog_prefix = $wpdb->get_blog_prefix($blog_id);
									$count = $wpdb->query("UPDATE {$blog_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
									$approved = 'spam';
									return new WP_Error( 'require_valid_email', __( '<strong>SPAM MASTER</strong>'. get_blog_option($blog_id, 'spam_master_message').'' ), 200 );
								}
								else{
									$table_prefix = $wpdb->base_prefix;
									$count = $wpdb->query("UPDATE {$table_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
									$approved = 'spam';
									return new WP_Error( 'require_valid_email', __( '<strong>SPAM MASTER</strong>'. get_option('spam_master_message').'' ), 200 );
								}
							return $approved;
							//end stripos
							}
						//end for
						}
					}
					if ($comment_arabic_char == 'true'){
						$blacklist_arabic_char_string = $comment_arabic_char_set;
						$blacklist_arabic_char_array = explode("\n", $blacklist_arabic_char_string);
						$blacklist_arabic_char_size = sizeof($blacklist_arabic_char_array);
						// Analyse List
						for($i = 0; $i < $blacklist_arabic_char_size; $i++){
							$blacklist_arabic_char_current = trim($blacklist_arabic_char_array[$i]);
							//check buffer
							if(stripos($commentdata['comment_content'], $blacklist_arabic_char_current) !== false){
								//add to buffer	ip and email
								$wpdb->insert( $table_threats, array( 'time' => current_time( 'mysql' ), 'threat' => $blog_threat_ip ));
								$wpdb->insert( $table_threats, array( 'time' => current_time( 'mysql' ), 'threat' => $result_comment_author_email ));
								//insert transient
								$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Comment', 'spamvalue' => 'Blocked using Arabic Char, ' . $blacklist_arabic_char_current . ', Ip: ' . $blog_threat_ip . ', Email: ' . $result_comment_author_email .  ', Text: ' . $result_comment_content_clean ));
								//Report only, create data to be posted
								$blog_web_address = get_site_url();
								$address_unclean = $blog_web_address;
								$address = preg_replace('#^https?://#', '', $address_unclean);
								@$blog_server_ip = $_SERVER['SERVER_ADDR'];
								//if empty ip
								if(empty($blog_server_ip) || $blog_server_ip == '0'){
									@$blog_server_ip = 'I '.gethostbyname($_SERVER['SERVER_NAME']);
								}
								$spam_master_learning_post = array(
																	'blog_license_key' => $blog_license_key,
																	'blog_threat_ip' => $blog_threat_ip,
																	'blog_threat_type' => $blog_threat_type,
																	'blog_threat_email' => $result_comment_author_email,
																	'blog_threat_content' => 'Arabic Char: '. $blacklist_arabic_char_current . 'Text: ' .$result_comment_content_clean,
																	'blog_web_adress' => $address,
																	'blog_server_ip' => $blog_server_ip
															);										
								$spam_master_leaning_url = 'aHR0cHM6Ly9zcGFtbWFzdGVyLnRlY2hnYXNwLmNvbS93cC1jb250ZW50L3BsdWdpbnMvc3BhbS1tYXN0ZXItYWRtaW5pc3RyYXRvci9pbmNsdWRlcy9sZWFybmluZy9nZXRfbGVhcm5fY29tLnBocA==';
								$response = wp_remote_post( base64_decode($spam_master_leaning_url), array(
																											'method' => 'POST',
																											'timeout' => 45,
																											'body' => $spam_master_learning_post
																											));
								if(is_multisite()){
									$blog_prefix = $wpdb->get_blog_prefix($blog_id);
									$count = $wpdb->query("UPDATE {$blog_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
									$approved = 'spam';
									return new WP_Error( 'require_valid_email', __( '<strong>SPAM MASTER</strong>'. get_blog_option($blog_id, 'spam_master_message').'' ), 200 );
								}
								else{
									$table_prefix = $wpdb->base_prefix;
									$count = $wpdb->query("UPDATE {$table_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
									$approved = 'spam';
									return new WP_Error( 'require_valid_email', __( '<strong>SPAM MASTER</strong>'. get_option('spam_master_message').'' ), 200 );
								}
							return $approved;
							//end stripos
							}
						//end for
						}
					}
					if ($comment_spam_char == 'true'){
						$blacklist_spam_char_string = $comment_spam_char_set;
						$blacklist_spam_char_array = explode("\n", $blacklist_spam_char_string);
						$blacklist_spam_char_size = sizeof($blacklist_spam_char_array);
						// Analyse List
						for($i = 0; $i < $blacklist_spam_char_size; $i++){
							$blacklist_spam_char_current = trim($blacklist_spam_char_array[$i]);
							//check buffer
							if(stripos($commentdata['comment_content'], $blacklist_spam_char_current) !== false){
								//add to buffer	ip and email
								$wpdb->insert( $table_threats, array( 'time' => current_time( 'mysql' ), 'threat' => $blog_threat_ip ));
								$wpdb->insert( $table_threats, array( 'time' => current_time( 'mysql' ), 'threat' => $result_comment_author_email ));
								//insert transient
								$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Comment', 'spamvalue' => 'Blocked using Spam Char, ' . $blacklist_spam_char_current . ', Ip: ' . $blog_threat_ip . ', Email: ' . $result_comment_author_email . ', Text: ' . $result_comment_content_clean ));
								//Report only, create data to be posted
								$blog_web_address = get_site_url();
								$address_unclean = $blog_web_address;
								$address = preg_replace('#^https?://#', '', $address_unclean);
								@$blog_server_ip = $_SERVER['SERVER_ADDR'];
								//if empty ip
								if(empty($blog_server_ip) || $blog_server_ip == '0'){
									@$blog_server_ip = 'I '.gethostbyname($_SERVER['SERVER_NAME']);
								}
								$spam_master_learning_post = array(
																	'blog_license_key' => $blog_license_key,
																	'blog_threat_ip' => $blog_threat_ip,
																	'blog_threat_type' => $blog_threat_type,
																	'blog_threat_email' => $result_comment_author_email,
																	'blog_threat_content' => 'Spam Char: '. $blacklist_spam_char_current . 'Text: ' .$result_comment_content_clean,
																	'blog_web_adress' => $address,
																	'blog_server_ip' => $blog_server_ip
															);										
								$spam_master_leaning_url = 'aHR0cHM6Ly9zcGFtbWFzdGVyLnRlY2hnYXNwLmNvbS93cC1jb250ZW50L3BsdWdpbnMvc3BhbS1tYXN0ZXItYWRtaW5pc3RyYXRvci9pbmNsdWRlcy9sZWFybmluZy9nZXRfbGVhcm5fY29tLnBocA==';
								$response = wp_remote_post( base64_decode($spam_master_leaning_url), array(
																											'method' => 'POST',
																											'timeout' => 45,
																											'body' => $spam_master_learning_post
																											));
								if(is_multisite()){
									$blog_prefix = $wpdb->get_blog_prefix($blog_id);
									$count = $wpdb->query("UPDATE {$blog_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
									$approved = 'spam';
									return new WP_Error( 'require_valid_email', __( '<strong>SPAM MASTER</strong>'. get_blog_option($blog_id, 'spam_master_message').'' ), 200 );
								}
								else{
									$table_prefix = $wpdb->base_prefix;
									$count = $wpdb->query("UPDATE {$table_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
									$approved = 'spam';
									return new WP_Error( 'require_valid_email', __( '<strong>SPAM MASTER</strong>'. get_option('spam_master_message').'' ), 200 );
								}
							return $approved;
							//End Stripos
							}
						//End for
						}
					}
				//End Char Check
				}

				/////////////////////////////////
				//lets process with normal checks
				//prepare threat buffer
				$is_buffer_threat = $wpdb->get_results(
									$wpdb->prepare( 
													"SELECT threat 
													FROM $table_threats
													WHERE threat = %s OR threat = %s", 
													$blog_threat_ip, $result_comment_author_email
									));
				if(!empty($is_buffer_threat)){
					//insert transient
					$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Comment', 'spamvalue' => 'Blocked by spam buffer, Ip: ' . $blog_threat_ip . ', Email: ' . $result_comment_author_email . ', Text: ' . $result_comment_content_clean ));
					if(is_multisite()){
						$blog_prefix = $wpdb->get_blog_prefix($blog_id);
						$count = $wpdb->query("UPDATE {$blog_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
						$approved = 'spam';
						return new WP_Error( 'require_valid_email', __( '<strong>SPAM MASTER</strong>'. get_blog_option($blog_id, 'spam_master_message').'' ), 200 );
					}
					else{
						$table_prefix = $wpdb->base_prefix;
						$count = $wpdb->query("UPDATE {$table_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
						$approved = 'spam';
						return new WP_Error( 'require_valid_email', __( '<strong>SPAM MASTER</strong>'. get_option('spam_master_message').'' ), 200 );
					}
					return $approved;
				}
				//buffer empty
				else{
					//create data to be posted
					$blog_web_address = get_site_url();
					$address_unclean = $blog_web_address;
					$address = preg_replace('#^https?://#', '', $address_unclean);
					@$blog_server_ip = $_SERVER['SERVER_ADDR'];
					//if empty ip
					if(empty($blog_server_ip) || $blog_server_ip == '0'){
						@$blog_server_ip = 'I '.gethostbyname($_SERVER['SERVER_NAME']);
					}
					$spam_master_learning_post = array(
														'blog_license_key' => $blog_license_key,
														'blog_threat_ip' => $blog_threat_ip,
														'blog_threat_type' => $blog_threat_type,
														'blog_threat_email' => $result_comment_author_email,
														'blog_threat_content' => $result_comment_content_clean,
														'blog_web_adress' => $address,
														'blog_server_ip' => $blog_server_ip
												);										
					$spam_master_leaning_url = 'aHR0cHM6Ly9zcGFtbWFzdGVyLnRlY2hnYXNwLmNvbS93cC1jb250ZW50L3BsdWdpbnMvc3BhbS1tYXN0ZXItYWRtaW5pc3RyYXRvci9pbmNsdWRlcy9sZWFybmluZy9nZXRfbGVhcm5fY29tLnBocA==';
					$response = wp_remote_post( base64_decode($spam_master_leaning_url), array(
																								'method' => 'POST',
																								'timeout' => 45,
																								'body' => $spam_master_learning_post
																								));
					if ( is_wp_error( $response ) ) {
						$error_message = $response->get_error_message();
						//Log
						$approved = '0';
						$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'System', 'spamvalue' => 'Error: Learning Comment. '.$error_message ));
						$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Comment', 'spamvalue' => 'Delivered with error, Ip: ' . $blog_threat_ip . ', Email: ' . $result_comment_author_email .  ', Text: ' . $result_comment_content_clean ));
						echo "Something went wrong, please get in touch with TechGasp Support: $error_message";
					}
					else{
						$data = json_decode( wp_remote_retrieve_body( $response ), true );
						if(empty($data)){
							$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Comment', 'spamvalue' => 'Delivered, Ip: ' . $blog_threat_ip . ', Email: ' . $result_comment_author_email .  ', Text: ' . $result_comment_content_clean ));
							$approved = '0';
						}
						else{
							$spam_threat = $data['threat'];
							//add to buffer	ip and email
							$wpdb->insert( $table_threats, array( 'time' => current_time( 'mysql' ), 'threat' => $blog_threat_ip ));
							$wpdb->insert( $table_threats, array( 'time' => current_time( 'mysql' ), 'threat' => $result_comment_author_email ));
							//insert transient
							$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Comment', 'spamvalue' => 'Blocked by online RBL, Ip: ' . $blog_threat_ip . ', Email: ' . $result_comment_author_email . ', Text: ' . $result_comment_content_clean ));
							if(is_multisite()){
								$blog_prefix = $wpdb->get_blog_prefix($blog_id);
								$count = $wpdb->query("UPDATE {$blog_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
								return new WP_Error( 'require_valid_email', __( '<strong>SPAM MASTER</strong>'. get_blog_option($blog_id, 'spam_master_message').'' ), 200 );
							}
							else{
								$table_prefix = $wpdb->base_prefix;
								$count = $wpdb->query("UPDATE {$table_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
								return new WP_Error( 'require_valid_email', __( '<strong>SPAM MASTER</strong>'. get_option('spam_master_message').'' ), 200 );
							}
							$approved = 'spam';
						}
						return $approved;
					}
				//end buffer empty
				}
			//end admin check
			}
		//end func comments
		}
	//end spam_master_comment_strict_on
	}
//end valid
}
?>
