<?php
// Multisite Block
if( is_multisite()){
	$response_key = get_blog_option($blog_id, 'spam_master_status');
	//Set malfunctions as VALID
	//post data if license status is valid
	if($response_key == 'VALID' || $response_key == 'MALFUNCTION_1' || $response_key == 'MALFUNCTION_2'){
		add_filter('wpmu_validate_user_signup', 'spam_master_email_check');
		function spam_master_email_check($result){
		global $wpdb, $blog_id;

			//Remote Ip
			$blog_threat_ip = $_SERVER['REMOTE_ADDR'];

			//prepare threat buffer
			$blog_threat_email = wp_strip_all_tags($result['user_email']);
			if (empty($blog_threat_email)) {
					$blog_threat_email = "Spam Bot";
			}

			//Add Tables
			$table_threats = $wpdb->prefix."spam_master_threats";
			$table_keys = $wpdb->prefix."spam_master_keys";
			$table_white = $wpdb->prefix."spam_master_white";

			//First check Alert and Flooding
			$spam_master_alert_level = get_blog_option($blog_id, 'spam_master_alert_level');
			if ($spam_master_alert_level == 'ALERT_2' || $spam_master_alert_level == 'ALERT_3'){
				$spam_master_last_contact =  $wpdb->get_var("SELECT time FROM $table_keys WHERE spamkey = 'Registration' ORDER BY time DESC LIMIT 1");
				$flood_date_plus_2 = date( 'Y-m-d H:i:s', current_time(strtotime($spam_master_last_contact . '+ 3 minute')));
				$flood_date = current_time('mysql');
				if($flood_date_plus_2 >= $flood_date){

					$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Registration', 'spamvalue' => 'Alert 2/3 warning, registration flooding detected from Ip: ' . $blog_threat_ip. ', Email: ' . $blog_threat_email ));

					echo '<p class="error"><strong>SPAM MASTER</strong> Flood detected. Please wait a few minutes.</p>';
					exit();
				}
			}

			//Log System
			$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Firewall', 'spamvalue' => 'Registration Spam Check Triggered. Incoming: '.$blog_threat_ip ));

			//Check White List
			$is_white = $wpdb->get_results(
						$wpdb->prepare( 
										"SELECT white 
										FROM $table_white
										WHERE white = %s OR white = %s", 
										$blog_threat_ip, $blog_threat_email
						));
			if(!empty($is_white)){
				//insert transient
				$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Registration', 'spamvalue' => 'Approved by whitelist and exempt from spam check, Ip: ' . $blog_threat_ip ));
			}
			else{
				//Check Spam Buffer
				$is_buffer_threat = $wpdb->get_results(
										$wpdb->prepare( 
														"SELECT threat 
														FROM $table_threats
														WHERE threat = %s OR threat = %s", 
														$blog_threat_ip, $blog_threat_email
										));
				if(!empty($is_buffer_threat)){
					//insert transient
					$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Registration', 'spamvalue' => 'Blocked by spam buffer, Ip: ' . $blog_threat_ip . ', Email: ' . $blog_threat_email ));
					$result['errors']->add('invalid_email',__('<strong>SPAM MASTER</strong>' . get_blog_option($blog_id, 'spam_master_message'),'spam_master'));
					$blog_prefix = $wpdb->get_blog_prefix($blog_id);
					$count = $wpdb->query("UPDATE {$blog_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
					echo '<p class="error"><strong>SPAM MASTER</strong>'.get_blog_option($blog_id, 'spam_master_message').'</p>';
				}
				//buffer empty
				else{
					//create data to be posted
					$blog_license_key = get_blog_option($blog_id, 'spam_license_key');
					$blog_threat_type = 'registration';
					$blog_threat_content = 'registration';
					$blog_web_address = get_site_url();
					$address_unclean = $blog_web_address;
					$address = preg_replace('#^https?://#', '', $address_unclean);
					@$blog_server_ip = $_SERVER['SERVER_ADDR'];
					//if empty ip
					if(empty($blog_server_ip) || $blog_server_ip == '0'){
						@$blog_server_ip = 'I '.gethostbyname($_SERVER['SERVER_NAME']);
					}
					$spam_master_learning_post = array(
														'blog_license_key' => $blog_license_key,
														'blog_threat_ip' => $blog_threat_ip,
														'blog_threat_type' => $blog_threat_type,
														'blog_threat_email' => $blog_threat_email,
														'blog_threat_content' => $blog_threat_content,
														'blog_web_adress' => $address,
														'blog_server_ip' => $blog_server_ip
												);										
					$spam_master_leaning_url = 'aHR0cHM6Ly9zcGFtbWFzdGVyLnRlY2hnYXNwLmNvbS93cC1jb250ZW50L3BsdWdpbnMvc3BhbS1tYXN0ZXItYWRtaW5pc3RyYXRvci9pbmNsdWRlcy9sZWFybmluZy9nZXRfbGVhcm5fcmVnLnBocA==';
					$response = wp_remote_post( base64_decode($spam_master_leaning_url), array(
																								'method' => 'POST',
																								'timeout' => 45,
																								'body' => $spam_master_learning_post
																						));
					if ( is_wp_error( $response ) ) {
						$error_message = $response->get_error_message();
						//Log
						$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'System', 'spamvalue' => 'Error: Learning Registration. '.$error_message ));
						$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Registration', 'spamvalue' => 'Approved with error, Ip: ' . $blog_threat_ip . ', Email: ' . $blog_threat_email ));
						echo "Something went wrong, please get in touch with TechGasp Support: $error_message";
					}
					else{
						$data = json_decode( wp_remote_retrieve_body( $response ), true );
						if(empty($data)){
							$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Registration', 'spamvalue' => 'Approved, Ip: ' . $blog_threat_ip . ', Email: ' . $blog_threat_email ));
						}
						else{
							$spam_threat = $data['threat'];
							//add to buffer	ip and email
							$wpdb->insert( $table_threats, array( 'time' => current_time( 'mysql' ), 'threat' => $blog_threat_ip ));
							$wpdb->insert( $table_threats, array( 'time' => current_time( 'mysql' ), 'threat' => $blog_threat_email ));
							//insert transient
							$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Registration', 'spamvalue' => 'Blocked by online RBL, Ip: ' . $blog_threat_ip . ', Email: ' . $blog_threat_email ));
							$result['errors']->add('invalid_email',__('<strong>SPAM MASTER</strong>' . get_blog_option($blog_id, 'spam_master_message'),'spam_master'));
							$blog_prefix = $wpdb->get_blog_prefix($blog_id);
							$count = $wpdb->query("UPDATE {$blog_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
							echo '<p class="error"><strong>SPAM MASTER</strong>'.get_blog_option($blog_id, 'spam_master_message').'</p>';
						}
					}
				//end buffer empty
				}
			//white else
			}
			return $result;
		//end func
		}
	//end valid
	}
//end multi
}
//SingleSite Block
else{
	//post data if license status is valid
	$response_key = get_option('spam_master_status');
	//Set malfunctions as VALID
	if($response_key == 'VALID' || $response_key == 'MALFUNCTION_1' || $response_key == 'MALFUNCTION_2'){
		add_action( 'register_post', 'spam_master', 10, 3 );
		function spam_master($user_login, $user_email, $errors){
		global $wpdb;

			//Remote Ip
			$blog_threat_ip = $_SERVER['REMOTE_ADDR'];

			//prepare threat buffer
			$blog_threat_email = wp_strip_all_tags($user_email);
			if (empty($blog_threat_email)) {
				$blog_threat_email = "Spam Bot";
			}

			//Add Tables
			$table_threats = $wpdb->prefix."spam_master_threats";
			$table_keys = $wpdb->prefix."spam_master_keys";
			$table_white = $wpdb->prefix."spam_master_white";

			//First check Alert and Flooding
			$spam_master_alert_level = get_option('spam_master_alert_level');
			if ($spam_master_alert_level == 'ALERT_2' || $spam_master_alert_level == 'ALERT_3'){
				$spam_master_last_contact =  $wpdb->get_var("SELECT time FROM $table_keys WHERE spamkey = 'Registration' ORDER BY time DESC LIMIT 1");
				$flood_date_plus_2 = date( 'Y-m-d H:i:s', current_time(strtotime($spam_master_last_contact . '+ 3 minute')));
				$flood_date = current_time('mysql');
				if($flood_date_plus_2 >= $flood_date){

					$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Registration', 'spamvalue' => 'Alert 2/3 warning, registration flooding detected from Ip: ' . $blog_threat_ip. ', Email: ' . $blog_threat_email ));

					$errors->add('invalid_email', '<strong>SPAM MASTER</strong> Flood detected. Please wait a few minutes.');
					return;
				}
			}

			//Log System
			$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Firewall', 'spamvalue' => 'Registration Spam Check Triggered. Incoming: '.$blog_threat_ip ));

			//Check White List
			$is_white = $wpdb->get_results(
						$wpdb->prepare( 
										"SELECT white 
										FROM $table_white
										WHERE white = %s OR white = %s", 
										$blog_threat_ip, $blog_threat_email
						));
			if(!empty($is_white)){
				//insert transient
				$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Registration', 'spamvalue' => 'Approved by whitelist and exempt from spam check, Ip: ' . $blog_threat_ip ));
			}
			else{
				//Check Spam Buffer
				$is_buffer_threat = $wpdb->get_results(
									$wpdb->prepare( 
													"SELECT threat 
													FROM $table_threats
													WHERE threat = %s OR threat = %s", 
													$blog_threat_ip, $blog_threat_email
									));
				if(!empty($is_buffer_threat)){
					//insert transient
					$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Registration', 'spamvalue' => 'Blocked by spam buffer, Ip: ' . $blog_threat_ip . ', Email: ' . $blog_threat_email ));
					$errors->add('invalid_email', '<strong>SPAM MASTER</strong>'.__( get_option('spam_master_message') ));
					$table_prefix = $wpdb->base_prefix;
					$count = $wpdb->query("UPDATE {$table_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
					return;
				}
				//buffer empty
				else{
					//create data to be posted
					$blog_license_key = get_option('spam_license_key');
					$blog_threat_type = 'registration';
					$blog_threat_content = 'registration';
					$blog_web_address = get_site_url();
					$address_unclean = $blog_web_address;
					$address = preg_replace('#^https?://#', '', $address_unclean);
					@$blog_server_ip = $_SERVER['SERVER_ADDR'];
					//if empty ip
					if(empty($blog_server_ip) || $blog_server_ip == '0'){
						@$blog_server_ip = 'I '.gethostbyname($_SERVER['SERVER_NAME']);
					}
					$spam_master_learning_post = array(
														'blog_license_key' => $blog_license_key,
														'blog_threat_ip' => $blog_threat_ip,
														'blog_threat_type' => $blog_threat_type,
														'blog_threat_email' => $blog_threat_email,
														'blog_threat_content' => $blog_threat_content,
														'blog_web_adress' => $address,
														'blog_server_ip' => $blog_server_ip
												);										
					$spam_master_leaning_url = 'aHR0cHM6Ly9zcGFtbWFzdGVyLnRlY2hnYXNwLmNvbS93cC1jb250ZW50L3BsdWdpbnMvc3BhbS1tYXN0ZXItYWRtaW5pc3RyYXRvci9pbmNsdWRlcy9sZWFybmluZy9nZXRfbGVhcm5fcmVnLnBocA==';
					$response = wp_remote_post( base64_decode($spam_master_leaning_url), array(
																								'method' => 'POST',
																								'timeout' => 45,
																								'body' => $spam_master_learning_post
																						));
					if ( is_wp_error( $response ) ) {
						$error_message = $response->get_error_message();
						//Log
						$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'System', 'spamvalue' => 'Error: Learning Registration. '.$error_message ));
						$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Registration', 'spamvalue' => 'Approved with error, Ip: ' . $blog_threat_ip . ', Email: ' . $blog_threat_email ));
						echo "Something went wrong, please get in touch with TechGasp Support: $error_message";
					}
					else{
						$data = json_decode( wp_remote_retrieve_body( $response ), true );
						if(empty($data)){
							$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Registration', 'spamvalue' => 'Approved, Ip: ' . $blog_threat_ip . ', Email: ' . $blog_threat_email ));
						}
						else{
							$spam_threat = $data['threat'];
							//add to buffer	ip and email
							$wpdb->insert( $table_threats, array( 'time' => current_time( 'mysql' ), 'threat' => $blog_threat_ip ));
							$wpdb->insert( $table_threats, array( 'time' => current_time( 'mysql' ), 'threat' => $blog_threat_email ));
							//insert transient
							$wpdb->insert( $table_keys, array( 'time' => current_time( 'mysql' ), 'spamkey' => 'Registration', 'spamvalue' => 'Blocked by online RBL, Ip: ' . $blog_threat_ip . ', Email: ' . $blog_threat_email ));
							$errors->add('invalid_email', '<strong>SPAM MASTER</strong>'.__( get_option('spam_master_message') ));
							$table_prefix = $wpdb->base_prefix;
							$count = $wpdb->query("UPDATE {$table_prefix}options SET option_value=option_value + 1 WHERE option_name='spam_master_block_count'");
							return;
						}
					}
				//end buffer empty
				}
			//white else
			}
		//end func
		}
	//end valid
	}
//end single
}
?>
