<?php
/*
Plugin Name: Colors
Description: adds colors
*/
add_action( 'init', 'color_manager_register' );

function color_manager_register(){
  $args = array(
    'label' => __( 'Colors' ),
    'singular_label' => __( 'Color' ),
    'public' => true,
    'show_ui' => true,
    'capability_type' => 'post',
    'hierarchical' => true,
    'has_archive' => true,
    'supports' => array( 'title', 'thumbnail' ),
    'rewrite' => array('slug' => 'color', 'with_front' => false),
  );
  
  register_post_type( 'color', $args );
  register_taxonomy( "color-type", array( "color" ), array("hierarchical" => true, "label" => "Color Types", "singular_label" => "Color Type", "rewrite" => true, "slug" => 'color-type') );
}

/*Adds Support for Featured Images**/
if (function_exists('add_theme_support')) {
    add_theme_support('post-thumbnails');
    add_image_size('colorpick', 20, 20, true);
}

// Moving Featured image box 
add_action('do_meta_boxes', 'customposttype_image_box');

function customposttype_image_box() {

  remove_meta_box( 'postimagediv', 'color', 'side' );

  add_meta_box('postimagediv', __('Color image'), 'post_thumbnail_meta_box', 'color', 'normal', 'high');

}

// End of moving featured image box

add_action( 'admin_init', 'color_manager_add_meta' );

function color_manager_add_meta(){
  add_meta_box( 'color-meta-box', 'Color', 'color_manager_meta_options', 'wpsc-product', 'normal', 'high' );  
}

function color_manager_meta_options(){

 
  
  echo '<style>
  
  .color-select-meta-box{
      position: relative;
      background: #fff;
      width: 222px;
  }
  
  .color-select-meta-box:hover .color-select-meta-box ul{
      display: block;
  }
  
  .color-select-caption{
      display: block;
      width: 220px;
      height: 25px;
      text-align: center;
      background: #fefefe;
      color: #333;
      line-height: 25px;
      border: 1px solid #ccc;
      text-decoration: none;
  }
  
  .color-select-meta-box ul{
      display: none;
      position: absolute;
      top: 25px;
      left: 0;
      width: 220px;
      margin: 0;
      padding: 0;
      background: #fff;
      border: 1px solid #ccc;   
  }
  
  #color-select-ul-inner{
      padding: 5px;
  }
  
  .color-select-meta-box ul li{
      display: block;
      float:left;
      padding: 1px;
      margin: 2px;   
  }
  
  .color-select-meta-box ul li:hover,
  .color-select-meta-box ul li.selected{
      background: #ccc;
  }
  
  .color-select-meta-box ul li:hover a{
      border: 1px solid #fff;
  }
  
  .color-select-meta-box ul li a{
      display: block;
      float: left;
      height: 20px;
      width: 20px;
      margin: 2px;
      padding: 2px;
      -webkit-border-radius: 10px;
      -moz-border-radius: 10px;
      border-radius: 10px;
      overflow: hidden;
      border: 1px solid #ccc;
      z-index: 9;
  }
  
  </style>';

  global $post;
  
  if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return $post_id;
  
  $custom = get_post_custom( $post->ID );
  $product_color = $custom['product_color'][0];
  
  $loop_args = array(
  'post_type' => 'color',
  'posts_per_page' => '-1',
  );

  // Save original loop for later
  $original_post = $post;
  $post = null;
  
  $color_loop = get_posts( $loop_args );

  
  echo '<div class="team_manager_extras">';

  // select box
  
  echo '<div class="color-select-meta-box">';
  
  echo '<a href="#" class="color-select-caption" onclick="if(document.getElementById(\"color-select-ul\").style.display==\"none\"){document.getElementById(\"color-select-ul\").style.display==\"block\"}else{document.getElementById(\"color-select-ul\").style.display==\"none\"}">Select color</a>';
  
  echo '<ul id="color-select-ul" style="display: none;">';
  echo '<div id="color-select-ul-inner" >';

  $prod_col_title = 'none';

  if ( true ) :
  
    foreach( $color_loop as $post ) : setup_postdata($post);
    
      echo '<li ' . ( ( $post->ID == $product_color ) ? 'class= "selected"' : '' ) . '><a href="#" val="';
      echo $post->ID;
      echo '" title="';
      echo $post->post_title;
      echo '">';
      echo get_the_post_thumbnail($post->ID, 'colorpick', array(
                  'title' => trim(strip_tags( $post->post_title )),
                )); 
      echo '</a></li>';

      if( $post->ID == $product_color ) { $prod_col_title = get_the_title(); }
      
    endforeach;

  else:

    echo 'Aucune couleur disponible';

  endif;

  // Reset loop now back to original post
  $post = null;
  $post = $original_post;
  wp_reset_postdata();
  
  echo "<div style='clear: both; height: 0; content: " . '"."' . "; visibility: hidden; display: block;'></div>";
  
  echo '<input type="hidden" name="product_color" value="' . $product_color . '">';
  
  echo '</div>';
    
  echo '</ul>';
  
  echo '</div>';

  ?>
  <script type="text/javascript">

  var $j = jQuery.noConflict();

  $j(function(){
      $j(".color-select-meta-box").click(function(event){
        event.preventDefault();
        $j("#color-select-ul").toggle('medium');
      });

      $j(".color-select-meta-box ul a").click(function(){
        var val = $j(this).attr('val');
        var name = $j(this).attr('title');
        $j(this).parent().parent().find("input[type='hidden']").attr('value',val);
        $j("#color-select-selected").html(name);
        //fix for e-commerce plugin
        $j( ".product_custom_meta input[value='product_color']" ).parent().find("textarea").val( val );
      });

	$j("#color-select-ul-inner li").click(function(){
		$j(this).siblings().removeClass("selected");
		$j(this).addClass("selected");
	});

  });

  </script>


  <?php

  // end select box 

  echo '<br>';

  echo 'Sélectionné: ';

  echo ' <span id="color-select-selected">' . $prod_col_title.'</span>';
  
  echo '</div>';
  
  
}

add_action( 'save_post', 'color_manager_save_extras' );

function color_manager_save_extras(){
  global $post;
  
  if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ){
    return $post_id;
  }else{
    update_post_meta( $post->ID, 'product_color', $_POST['product_color'] );
  }
}


?>
