<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" <?php language_attributes(); ?>>
<head profile="http://gmpg.org/xfn/11">
    <title><?php
        if ( is_single() ) { single_post_title(); }
        elseif ( is_home() || is_front_page() ) { bloginfo('name'); print ' | '; bloginfo('description'); get_page_number(); }
        elseif ( is_page() ) { single_post_title(''); }
        elseif ( is_search() ) { bloginfo('name'); print ' | Search results for ' . wp_specialchars($s); get_page_number(); }
        elseif ( is_404() ) { bloginfo('name'); print ' | Not Found'; }
        else { bloginfo('name'); wp_title('|'); get_page_number(); }
    ?></title>
 
    <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />

    <link rel="shortcut icon" href="<?php bloginfo('stylesheet_directory'); ?>/favicon.ico" />
 
    <link rel="stylesheet" href="<?php bloginfo('stylesheet_url'); echo '?' . filemtime( get_stylesheet_directory() . '/style.css'); ?>" type="text/css" media="screen, projection" />
 
    <?php if ( is_singular() ) wp_enqueue_script( 'comment-reply' ); ?>

    <?php wp_head(); ?>
 
    <link rel="alternate" type="application/rss+xml" href="<?php bloginfo('rss2_url'); ?>" title="<?php printf( __( '%s latest posts', 'hbd-theme' ), wp_specialchars( get_bloginfo('name'), 1 ) ); ?>" />
    <link rel="alternate" type="application/rss+xml" href="<?php bloginfo('comments_rss2_url') ?>" title="<?php printf( __( '%s latest comments', 'hbd-theme' ), wp_specialchars( get_bloginfo('name'), 1 ) ); ?>" />
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
	

	<?php
	if(is_home())
	{ // Home page background effect
		
	?>
		


	<?php 

	 	
	}
	?>
</head>
<body <?php body_class(); ?>>
<div id="wrapper" class="hfeed">
	<?php 
	if( is_home() ){
	?>
		<table id="home-page-frame" border="0" cellpadding="0" cellspacing="0" width="97%" style="position: relative; top: -3px; width: 97%; height: 97%; margin: 0 auto; border-collapse:collapse; ">
			<tr height="100%" valign="top">
				<td style="padding-top: 10px; border-left:3px solid #fff; border-right:3px solid #fff;">
	<?php 
	} 
	?>
    <div id="header" align="center";>
		<?php
			if(is_home())
			{
				echo '<div id="masthead-home-not" align="center">';
			}
			else
			{
				echo '<div id="masthead" align="center">';
			}
		?>
        
		
 			<?php
				if(is_home()){
			?>
			<div id="logo">
				<a href="<?php bloginfo('url'); ?>">
					<img id="logo-img" title="<?php bloginfo('name') ?>" alt="<?php bloginfo('name') ?>" src="<?php bloginfo('template_directory'); ?>/img/logo-white.png"/>
				</a>
			</div>
            <div id="home_buttons">
  
				<?php wp_nav_menu( array( 'theme_location' => 'menu-3' ) ); ?>

				<style>
					#home_buttons ul li a{
						display: inline-block;
						margin: 0;
						padding: 5px 0 5px 5px !important;
					}
				</style>
			</div>
 			<?php
				}
				else
				{
			?>
			<div id="logo">
				<a href="<?php bloginfo('url'); ?>">
					<img id="logo-img" title="<?php bloginfo('name') ?>" alt="<?php bloginfo('name') ?>" src="<?php bloginfo('template_directory'); ?>/img/logo-black.png"/>
				</a>
			</div>
			<div id="menu_holder">
				<?php wp_nav_menu( array( 'theme_location' => 'menu-1' ) ); ?>
			</div>
			
			<?php		
				}
			?>
        </div><!-- #masthead -->
    </div><!-- #header -->
    <div id="main" align="center">
