<?php

/* Add featured article meta box for post type */

add_action( 'admin_init', 'iwb_featured_article_add_meta' );

function iwb_featured_article_add_meta(){
	add_meta_box( 'iwb-featured-article-meta-box', 'Featured Article', 'iwb_featured_article_manager', 'post', 'side', 'high' ); 
}

function iwb_featured_article_manager(){

	global $post;
  
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return $post_id;

	$custom = get_post_custom( $post->ID );
	$iwb_featured_article = $custom['iwb_featured_article'][0];

	echo '<label for="iwb_featured_article" style="display: block; height:15px; line-height: 15px; background: url(../images/stars.png) no-repeat left top;">
	<input type="checkbox" id="iwb_featured_article" name="iwb_featured_article" style="width: 21px; height: 15px; /*opacity: 0; filter:alpha(opacity=0);*/"' .  
	( ( $iwb_featured_article == 'on' ) ? 'checked' : '' ) . '> Featured</label>';

}

add_action( 'save_post', 'iwb_featured_article_save' );

function iwb_featured_article_save(){
  global $post;
  
  if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ){
    return $post_id;
  }else{
    update_post_meta( $post->ID, 'iwb_featured_article', $_POST['iwb_featured_article'] );
  }
}


?>