<?php
/*
Plugin Name: FAQ - CPT for adding/removing FAQ 
Description: Adds/removes FAQ
*/
add_action( 'init', 'faq_manager_register' );

function faq_manager_register(){
  $args = array(
    'label' => __( 'FAQ' ),
    'singular_label' => __( 'FAQ' ),
    'public' => true,
    'show_ui' => true,
    'capability_type' => 'post',
    'hierarchical' => true,
    'has_archive' => true,
    'supports' => array( 'title','editor' ),
    'rewrite' => array('slug' => 'faq', 'with_front' => false),
  );
  
  register_post_type( 'FAQ', $args );
  register_taxonomy( "faq-cpt", array( "faq" ), array("hierarchical" => true, "label" => "FAQ categories", "singular_label" => "FAQ category", "rewrite" => true, "slug" => 'faq') );
}

add_action( 'admin_init', 'faq_manager_add_meta' );

function faq_manager_add_meta(){
  add_meta_box( 'faq-meta-box', 'FAQ', 'faq_manager_meta_options', 'wpsc-product', 'normal', 'high' );  
}

function faq_manager_meta_options(){

 
  
  echo '<style>
  
  .faq-select-meta-box{
      position: relative;
      background: #fff;
      width: 222px;
  }
  
  .faq-select-meta-box:hover .faq-select-meta-box ul{
      display: block;
  }
  
  .faq-select-caption{
      display: block;
      width: 220px;
      height: 25px;
      text-align: center;
      background: #fefefe;
      faq: #333;
      line-height: 25px;
      border: 1px solid #ccc;
      text-decoration: none;
  }
  
  .faq-select-meta-box ul{
      display: none;
      position: absolute;
      top: 25px;
      left: 0;
      width: 220px;
      margin: 0;
      padding: 0;
      background: #fff;
      border: 1px solid #ccc;   
  }
  
  #faq-select-ul-inner{
      padding: 5px;
  }
  
  .faq-select-meta-box ul li{
      display: block;
      float:left;
      padding: 1px;
      margin: 2px;   
  }
  
  .faq-select-meta-box ul li:hover,
  .faq-select-meta-box ul li.selected{
      background: #ccc;
  }
  
  .faq-select-meta-box ul li:hover a{
      border: 1px solid #fff;
  }
  
  .faq-select-meta-box ul li a{
      display: block;
      float: left;
      height: 20px;
      width: 20px;
      margin: 2px;
      padding: 2px;
      -webkit-border-radius: 10px;
      -moz-border-radius: 10px;
      border-radius: 10px;
      overflow: hidden;
      border: 1px solid #ccc;
      z-index: 9;
  }
  
  </style>';

  global $post;
  
  if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return $post_id;
  
  $custom = get_post_custom( $post->ID );
  $product_faq = $custom['product_faq'][0];
  
  $loop_args = array(
  'post_type' => 'faq',
  );

  // Save original loop for later
  $original_post = $post;
  $post = null;
  
  $faq_loop = get_posts( $loop_args );

  
  echo '<div class="team_manager_extras">';

  // select box
  
  echo '<div class="faq-select-meta-box">';
  
  echo '<a href="#" class="faq-select-caption" onclick="if(document.getElementById(\"faq-select-ul\").style.display==\"none\"){document.getElementById(\"faq-select-ul\").style.display==\"block\"}else{document.getElementById(\"faq-select-ul\").style.display==\"none\"}">Select faq</a>';
  
  echo '<ul id="faq-select-ul" style="display: none;">';
  echo '<div id="faq-select-ul-inner" >';

  $prod_col_title = 'none';

  if ( true ) :
  
    foreach( $faq_loop as $post ) : setup_postdata($post);
    
      echo '<li ' . ( ( $post->ID == $product_faq ) ? 'class= "selected"' : '' ) . '><a href="#" val="';
      echo $post->ID;
      echo '" title="';
      echo $post->post_title;
      echo '">';
      echo get_the_post_thumbnail($post->ID, 'faqpick', array(
                  'title' => trim(strip_tags( $post->post_title )),
                )); 
      echo '</a></li>';

      if( $post->ID == $product_faq ) { $prod_col_title = get_the_title(); }
      
    endforeach;

  else:

    echo 'No faqs are inserted yet.';

  endif;

  // Reset loop now back to original post
  $post = null;
  $post = $original_post;
  wp_reset_postdata();
  
  echo "<div style='clear: both; height: 0; content: " . '"."' . "; visibility: hidden; display: block;'></div>";
  
  echo '<input type="hidden" name="product_faq" value="' . $product_faq . '">';
  
  echo '</div>';
    
  echo '</ul>';
  
  echo '</div>';

  ?>
  <script type="text/javascript">

  var $j = jQuery.noConflict();

  $j(function(){
      $j(".faq-select-meta-box").click(function(event){
        event.preventDefault();
        $j("#faq-select-ul").toggle('medium');
      });

      $j(".faq-select-meta-box ul a").click(function(){
        var val = $j(this).attr('val');
        var name = $j(this).attr('title');
        $j(this).parent().parent().find("input[type='hidden']").attr('value',val);
        $j("#faq-select-selected").html(name);
        //fix for e-commerce plugin
        $j( ".product_custom_meta input[value='product_faq']" ).parent().find("textarea").val( val );
      });

  });

  </script>


  <?php

  // end select box 

  echo '<br>';

  echo 'selected: ';

  echo ' <span id="faq-select-selected">' . $prod_col_title.'</span>';
  
  echo '</div>';
  
  
}

add_action( 'save_post', 'faq_manager_save_extras' );

function faq_manager_save_extras(){
  global $post;
  
  if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ){
    return $post_id;
  }else{
    update_post_meta( $post->ID, 'product_faq', $_POST['product_faq'] );
  }
}


?>