<?php
/*
Plugin Name: WPeC Share da Orders
Description: WordPress plugin that allow you to share your order on Facebook
Version: 1.0
Author: Inside Da Web
Author URI: http://www.insidedaweb.com/
*/

define( 'WPEC_SDO_DIR_PATH', plugin_dir_path( __FILE__ ) );

register_activation_hook( __FILE__, 'wpec_sdo_install' );

add_action( 'admin_menu', 'wpec_sdo_create_menu' );

add_action(  'admin_init', 'wpec_sdo_register_settings' );

add_shortcode( 'wpec_share_da_orders', 'wpec_sdo_shortcode' );


/*
* Install plugin
*/
function wpec_sdo_install(){
	// If WP version is lower than needed, then deactivate plugin
	if( version_compare( get_bloginfo('version'), '4.0', '<' ) ){
		deactivate_plugins( basename( __FILE__ ) ); 
	}
}

/*
* Create submenu for settings page
*/
function wpec_sdo_create_menu(){
	add_submenu_page( 'edit.php?post_type=wpsc-product', 'WPeC Share da Orders Options', 'Share Product', 'administrator', __FILE__, 'wpec_sdo_settings_page' );
}

/*
* Register plugin settings
*/
function wpec_sdo_register_settings(){
	register_setting( 'wpec_sdo_settings', 'wpec_sdo_fb_app_id' );
	register_setting( 'wpec_sdo_settings', 'wpec_sdo_message_type' );
	register_setting( 'wpec_sdo_settings', 'wpec_sdo_message' );
	register_setting( 'wpec_sdo_settings', 'wpec_sdo_caption' );
	register_setting( 'wpec_sdo_settings', 'wpec_sdo_description_type' );
	register_setting( 'wpec_sdo_settings', 'wpec_sdo_description' );
	register_setting( 'wpec_sdo_settings', 'wpec_sdo_show_image' );
	register_setting( 'wpec_sdo_settings', 'wpec_sdo_button_text' );
	register_setting( 'wpec_sdo_settings', 'wpec_sdo_button_look' );
	register_setting( 'wpec_sdo_settings', 'wpec_sdo_button_id' );
	register_setting( 'wpec_sdo_settings', 'wpec_sdo_return_to_type' );
	register_setting( 'wpec_sdo_settings', 'wpec_sdo_return_to_url' );
	register_setting( 'wpec_sdo_settings', 'wpec_sdo_prod_page_type' );
	register_setting( 'wpec_sdo_settings', 'wpec_sdo_prod_page' );
}


/*
* Customize settings page
*/
function wpec_sdo_settings_page(){

	?>

	<div class="wrap">
		
		<?php screen_icon('plugins'); ?><h2>WPeC Share da Orders Settings Page</h2>

		<div id="message" class="updated" style="display: none;">Setting saved successfully</div>
		<div id="message" class="error" style="display: none;">Error saving settings</div>

		<form action="options.php" method="post">
			<?php
			settings_fields( 'wpec_sdo_settings' );

			$wpec_sdo_fb_app_id = ( strlen( get_option( 'wpec_sdo_fb_app_id' ) ) > 0 ) ? get_option( 'wpec_sdo_fb_app_id' ) : '';

			$wpec_sdo_message_type = ( get_option( 'wpec_sdo_message_type' ) == 'wpec_sdo_custom_msg' ) ? 'wpec_sdo_custom_msg' : 'wpec_sdo_default_msg';
			$wpec_sdo_description_type = ( get_option( 'wpec_sdo_description_type' ) == 'wpec_sdo_custom_desc' ) ? 'wpec_sdo_custom_desc' : 'wpec_sdo_default_desc';
			$wpec_sdo_return_to_type = ( get_option( 'wpec_sdo_return_to_type' ) == 'wpec_sdo_custom_return' ) ? 'wpec_sdo_custom_return' : 'wpec_sdo_default_return';
			$wpec_sdo_prod_page_type = ( get_option( 'wpec_sdo_prod_page_type' ) == 'wpec_sdo_custom_prod_page' ) ? 'wpec_sdo_custom_prod_page' : 'wpec_sdo_default_prod_page';
			
			$wpec_sdo_message = ( strlen( get_option( 'wpec_sdo_message' ) ) > 0 ) ? get_option( 'wpec_sdo_message' ) : '';
			$wpec_sdo_caption = ( strlen( get_option( 'wpec_sdo_caption' ) ) > 0 ) ? get_option( 'wpec_sdo_caption' ) : '';
			$wpec_sdo_description = ( strlen( get_option( 'wpec_sdo_description' ) ) > 0 ) ? get_option( 'wpec_sdo_description' ) : '';
			$wpec_sdo_button_look = ( get_option( 'wpec_sdo_button_look' ) == 'wpec_sdo_custom_btn' ) ? 'wpec_sdo_custom_btn' : 'wpec_sdo_default_btn';
			$wpec_sdo_button_text = ( strlen( get_option( 'wpec_sdo_button_text' ) ) > 0 ) ? get_option( 'wpec_sdo_button_text' ) : '';
			$wpec_sdo_return_to_url = ( strlen( get_option( 'wpec_sdo_return_to_url' ) ) > 0 ) ? get_option( 'wpec_sdo_return_to_url' ) : '';
			$wpec_sdo_show_image = ( get_option( 'wpec_sdo_show_image' ) == 'on') ? 'checked' : '';
			$wpec_sdo_prod_page = ( strlen( get_option( 'wpec_sdo_prod_page' ) ) > 0 ) ? get_option( 'wpec_sdo_prod_page' ) : '';
			$wpec_sdo_button_id = ( strlen( get_option( 'wpec_sdo_button_id' ) ) > 0 ) ? get_option( 'wpec_sdo_button_id' ) : '';
			

			?>
			<table class="form-table">

				<!-- APP SETUP -->

				<tr valign="top">
					<th scope="row"><h3>App setup</h3></th>
					<td></td>
				</tr>

				<tr valign="top">
					<th scope="row"><label>Facebook App key:</label></th>
					<td><input type="text" name="wpec_sdo_fb_app_id" size="60" value="<?php print $wpec_sdo_fb_app_id; ?>"/></td>
				</tr>

				<!-- MESSAGE CONTENT SETUP -->

				<tr valign="top">
					<th scope="row"><h3>Message content setup</h3></th>
					<td></td>
				</tr>

				<tr valign="top">
					<th scope="row"><label>Message:</label></th>
					<td><input type="radio" name="wpec_sdo_message_type" value="wpec_sdo_default_msg" <?php if( $wpec_sdo_message_type == 'wpec_sdo_default_msg' ) { print 'checked'; } ?> /> Default Message:
						<p>Hey, I have just made a purchase on <?php print get_bloginfo('name'); ?></p>
						<p><input type="radio" name="wpec_sdo_message_type" value="wpec_sdo_custom_msg" <?php if( $wpec_sdo_message_type == 'wpec_sdo_custom_msg' ) { print 'checked'; } ?> /> Custom message:</p>
						<input type="text" name="wpec_sdo_message" size="60" value="<?php print $wpec_sdo_message; ?>"/>
					</td>
				</tr>


				<tr valign="top">
					<th scope="row"><label>Caption (otptional):</label></th>
					<td>
						<input type="text" name="wpec_sdo_caption" size="60" value="<?php print $wpec_sdo_caption; ?>"/>
					</td>
				</tr>

				<tr valign="top">
					<th scope="row"><label>Aditional Description (otptional):</label></th>
					<td>
						<p><input type="radio" name="wpec_sdo_description_type" value="wpec_sdo_default_desc" <?php if( $wpec_sdo_description_type == 'wpec_sdo_default_desc' ) { print 'checked'; } ?> /> Default description (Your website description):</p>
						<p><?php print get_bloginfo('description'); ?></p>
						<p><input type="radio" name="wpec_sdo_description_type" value="wpec_sdo_custom_desc" <?php if( $wpec_sdo_description_type == 'wpec_sdo_custom_desc' ) { print 'checked'; } ?> /> Custom description:</p>
						<textarea name="wpec_sdo_description" rows="5" cols="62" ><?php print $wpec_sdo_description; ?></textarea>
					</td>
				</tr>

				<tr valign="top">
					<th scope="row"><label>Show product image:</label></th>
					<td>
						<input type="checkbox" name="wpec_sdo_show_image" <?php print $wpec_sdo_show_image; ?> /> Yes
					</td>
				</tr>

				<!-- RETURN PAGE -->

				<tr valign="top">
					<th scope="row"><h3>After work is done</h3></th>
					<td></td>
				</tr>

				<tr valign="top">
					<th scope="row"><label>Return to :</label></th>
					<td>
						<input type="radio" name="wpec_sdo_return_to_type" value="wpec_sdo_default_return" <?php if( $wpec_sdo_return_to_type == 'wpec_sdo_default_return' ) { print 'checked'; } ?> /> Home Page:
						<p><?php print home_url(); ?></p>

						<p><input type="radio" name="wpec_sdo_return_to_type" value="wpec_sdo_custom_return" <?php if( $wpec_sdo_return_to_type == 'wpec_sdo_custom_return' ) { print 'checked'; } ?> /> Custom URL:</p>
						<input type="text" name="wpec_sdo_return_to_url" size="60" value="<?php print $wpec_sdo_return_to_url; ?>"/>
					</td>
				</tr>

				<tr valign="top">
					<th scope="row"><label>Facebook link leads to:</label></th>
					<td>
						<input type="radio" name="wpec_sdo_prod_page_type" value="wpec_sdo_default_prod_page" <?php if( $wpec_sdo_prod_page_type == 'wpec_sdo_default_prod_page' ) { print 'checked'; } ?> /> Home Page:
						<p><?php print home_url(); ?></p>

						<p><input type="radio" name="wpec_sdo_prod_page_type" value="wpec_sdo_custom_prod_page" <?php if( $wpec_sdo_prod_page_type == 'wpec_sdo_custom_prod_page' ) { print 'checked'; } ?> /> Custom URL:</p>
						<label><?php print home_url(); ?>/</label><input type="text" name="wpec_sdo_prod_page" size="60" value="<?php print $wpec_sdo_prod_page; ?>"/>
						<p>This is relative address. ex. '?page_id=293'</p>
					</td>
				</tr>

				<!-- SHARE BUTTON SETUP -->
				
				<tr valign="top">
					<th scope="row"><h3>Share button setup</h3></th>
					<td></td>
				</tr>

				<tr valign="top">
					<th scope="row"><label>Button text:</label></th>
					<td>
						<input type="text" name="wpec_sdo_button_text" size="60" value="<?php print $wpec_sdo_button_text; ?>" /> 
					</td>
				</tr>

				<tr valign="top">
					<th scope="row"><label>Button look:</label></th>
					<td>
						<input type="radio" name="wpec_sdo_button_look" value="wpec_sdo_default_btn" <?php if( $wpec_sdo_button_look == 'wpec_sdo_default_btn' ) { print 'checked'; } ?> /> Default:
						<p>
							<a href="#" style="display: block; float: left; height: 28px; line-height: 28px; text-align:center; padding: 0 10px; background: #eee; text-decoration: none; color: #555; font-weight: bold; border: 1px solid #ddd; moz-border-radius: 3px; webkit-border-radius: 3px; border-radius: 3px;">Share da Orders</a>
						</p>
						<p> &nbsp; </p>
						<p><input type="radio" name="wpec_sdo_button_look" value="wpec_sdo_custom_btn" <?php if( $wpec_sdo_button_look == 'wpec_sdo_custom_btn' ) { print 'checked'; } ?> /> Custom id:</p>
						<p>id=&quot;<input type="text"  size="60" name="wpec_sdo_button_id" value="<?php print $wpec_sdo_button_id; ?>" />&quot;</p>
					</td>
				</tr>


				<tr valign="top">
					<td><input type="submit" name="Save" value="<?php _e('Save Changes') ?>" class="button-primary" /></td>
				</tr>

			</table>
		</form>

	</div>

	<?php
}

/*
* Handles shortcode
*/
function wpec_sdo_shortcode(){

	/*
	Example:

	http://www.facebook.com/dialog/feed?
	  app_id=123050457758183&
	  link=http://developers.facebook.com/docs/reference/dialogs/&
	  picture=http://fbrell.com/f8.jpg&
	  name=Facebook%20Dialogs&
	  caption=Reference%20Documentation&
	  description=Using%20Dialogs%20to%20interact%20with%20users.&
	  redirect_uri=http://www.example.com/response

	*/

	$wpec_sdo_output = '';
	//settings_fields( 'wpec_sdo_settings' );

	// Link to products
	if ( get_option( 'wpec_sdo_prod_page_type' ) == 'wpec_sdo_default_prod_page' ){
		$wpec_sdo_link = home_url();
	}else{
		$wpec_sdo_link = home_url() . '/' . get_option( 'wpec_sdo_prod_page' );
	}

	$wpec_sdo_product_image_url = '';

	if( wpsc_cart_item_count() > 0 ):
		while( wpsc_have_cart_items() ): wpsc_the_cart_item();
			$wpec_sdo_product_ids .= ( $wpec_sdo_product_ids == '' ) ? wpsc_cart_item_product_id() : ( ',' . wpsc_cart_item_product_id() );
			if ( wpsc_the_cart_item_key() == '0' ){
				$wpec_sdo_product_image_url = wp_get_attachment_image_src( get_post_thumbnail_id( wpsc_cart_item_product_id() ), 'thumbnail' );
			}
		endwhile;
	endif;

	$wpec_sdo_link .= '&ids=' . $wpec_sdo_product_ids;

	$wpec_sdo_link .= '&sh_rel=0';

	$wpec_sdo_link = urlencode( $wpec_sdo_link );

	get_post_thumbnail_id( $post_id );


	if( strlen( get_option( 'wpec_sdo_fb_app_id' ) ) > 0 ){

		// Link to Facebook
		$wpec_sdo_output .= '<a href="http://www.facebook.com/dialog/feed?app_id=' . get_option( 'wpec_sdo_fb_app_id' );

		// Link to page with order
		$wpec_sdo_output .= '&link=' . $wpec_sdo_link; 

		// Message
		if (  get_option( 'wpec_sdo_message_type' ) ==  'wpec_sdo_custom_msg' && strlen( get_option( 'wpec_sdo_message' ) ) > 0 ){
			$wpec_sdo_output .= '&name='. urlencode( get_option( 'wpec_sdo_message' ) );
		}
		else{
			$wpec_sdo_output .= '&name='. urlencode( 'Hey, I have just made a purchase on' . get_bloginfo('name') );
		}

		// Image of first product
		if( get_option( 'wpec_sdo_show_image' ) == 'on' && strlen( $wpec_sdo_product_image_url ) > 0 ){
			$wpec_sdo_output .= '&picture=' . urlencode( $wpec_sdo_product_image_url[0] );
		}

		// Caption
		if ( strlen( get_option( 'wpec_sdo_caption' ) ) > 0 ){
			$wpec_sdo_output .= '&caption=' . urlencode( get_option( 'wpec_sdo_caption' ) );
		}

		// Description
		if (  get_option( 'wpec_sdo_description_type' ) ==  'wpec_sdo_custom_desc' && strlen( get_option( 'wpec_sdo_description' ) ) > 0 ){
			$wpec_sdo_output .= '&description='. urlencode( get_option( 'wpec_sdo_description' ) );
		}
		else{
			$wpec_sdo_output .= '&description='. urlencode( get_bloginfo('description') );
		}

		// Return to URL
		if (  get_option( 'wpec_sdo_return_to_type' ) ==  'wpec_sdo_custom_return' && strlen( get_option( 'wpec_sdo_return_to_url' ) ) > 0 ){
			$wpec_sdo_output .= '&redirect_uri='. urlencode( get_option( 'wpec_sdo_return_to_url' ) );
		}
		else{
			$wpec_sdo_output .= '&redirect_uri='. urlencode( home_url() );
		}

		// End of URL
		$wpec_sdo_output .='"';

		// Button style
		if( get_option( 'wpec_sdo_button_look' ) == 'wpec_sdo_custom_btn' && strlen( get_option( 'wpec_sdo_button_id' ) ) > 0 ){
			$wpec_sdo_output .= ' id="' . get_option( 'wpec_sdo_button_id' ) . '" ';
		}else{
			$wpec_sdo_output .= ' style="display: block; float: left; height: 28px; line-height: 28px; text-align:center; padding: 0 10px; background: #eee; text-decoration: none; color: #555; font-weight: bold; border: 1px solid #ddd; moz-border-radius: 3px; webkit-border-radius: 3px; border-radius: 3px;" ';
		}

		// Button text
		$wpec_sdo_output .= ' title="' . get_option( 'wpec_sdo_button_text' ) . '">' . get_option( 'wpec_sdo_button_text' ) . '</a>' ;

	}
		
	return $wpec_sdo_output;
}


?>