<?php
 namespace MailPoetVendor\Doctrine\DBAL; if (!defined('ABSPATH')) exit; use Closure; use MailPoetVendor\Doctrine\Common\EventManager; use MailPoetVendor\Doctrine\DBAL\Cache\ArrayStatement; use MailPoetVendor\Doctrine\DBAL\Cache\CacheException; use MailPoetVendor\Doctrine\DBAL\Cache\QueryCacheProfile; use MailPoetVendor\Doctrine\DBAL\Cache\ResultCacheStatement; use MailPoetVendor\Doctrine\DBAL\Driver\Connection as DriverConnection; use MailPoetVendor\Doctrine\DBAL\Driver\PingableConnection; use MailPoetVendor\Doctrine\DBAL\Driver\ResultStatement; use MailPoetVendor\Doctrine\DBAL\Driver\ServerInfoAwareConnection; use MailPoetVendor\Doctrine\DBAL\Driver\Statement as DriverStatement; use MailPoetVendor\Doctrine\DBAL\Exception\InvalidArgumentException; use MailPoetVendor\Doctrine\DBAL\Platforms\AbstractPlatform; use MailPoetVendor\Doctrine\DBAL\Query\Expression\ExpressionBuilder; use MailPoetVendor\Doctrine\DBAL\Query\QueryBuilder; use MailPoetVendor\Doctrine\DBAL\Schema\AbstractSchemaManager; use MailPoetVendor\Doctrine\DBAL\Types\Type; use Exception; use Throwable; use function array_key_exists; use function array_merge; use function assert; use function func_get_args; use function implode; use function is_int; use function is_string; use function key; class Connection implements \MailPoetVendor\Doctrine\DBAL\Driver\Connection { public const TRANSACTION_READ_UNCOMMITTED = \MailPoetVendor\Doctrine\DBAL\TransactionIsolationLevel::READ_UNCOMMITTED; public const TRANSACTION_READ_COMMITTED = \MailPoetVendor\Doctrine\DBAL\TransactionIsolationLevel::READ_COMMITTED; public const TRANSACTION_REPEATABLE_READ = \MailPoetVendor\Doctrine\DBAL\TransactionIsolationLevel::REPEATABLE_READ; public const TRANSACTION_SERIALIZABLE = \MailPoetVendor\Doctrine\DBAL\TransactionIsolationLevel::SERIALIZABLE; public const PARAM_INT_ARRAY = \MailPoetVendor\Doctrine\DBAL\ParameterType::INTEGER + self::ARRAY_PARAM_OFFSET; public const PARAM_STR_ARRAY = \MailPoetVendor\Doctrine\DBAL\ParameterType::STRING + self::ARRAY_PARAM_OFFSET; public const ARRAY_PARAM_OFFSET = 100; protected $_conn; protected $_config; protected $_eventManager; protected $_expr; private $isConnected = \false; private $autoCommit = \true; private $transactionNestingLevel = 0; private $transactionIsolationLevel; private $nestTransactionsWithSavepoints = \false; private $params = []; private $platform; protected $_schemaManager; protected $_driver; private $isRollbackOnly = \false; protected $defaultFetchMode = \MailPoetVendor\Doctrine\DBAL\FetchMode::ASSOCIATIVE; public function __construct(array $params, \MailPoetVendor\Doctrine\DBAL\Driver $driver, ?\MailPoetVendor\Doctrine\DBAL\Configuration $config = null, ?\MailPoetVendor\Doctrine\Common\EventManager $eventManager = null) { $this->_driver = $driver; $this->params = $params; if (isset($params['pdo'])) { $this->_conn = $params['pdo']; $this->isConnected = \true; unset($this->params['pdo']); } if (isset($params['platform'])) { if (!$params['platform'] instanceof \MailPoetVendor\Doctrine\DBAL\Platforms\AbstractPlatform) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::invalidPlatformType($params['platform']); } $this->platform = $params['platform']; unset($this->params['platform']); } if (!$config) { $config = new \MailPoetVendor\Doctrine\DBAL\Configuration(); } if (!$eventManager) { $eventManager = new \MailPoetVendor\Doctrine\Common\EventManager(); } $this->_config = $config; $this->_eventManager = $eventManager; $this->_expr = new \MailPoetVendor\Doctrine\DBAL\Query\Expression\ExpressionBuilder($this); $this->autoCommit = $config->getAutoCommit(); } public function getParams() { return $this->params; } public function getDatabase() { return $this->_driver->getDatabase($this); } public function getHost() { return $this->params['host'] ?? null; } public function getPort() { return $this->params['port'] ?? null; } public function getUsername() { return $this->params['user'] ?? null; } public function getPassword() { return $this->params['password'] ?? null; } public function getDriver() { return $this->_driver; } public function getConfiguration() { return $this->_config; } public function getEventManager() { return $this->_eventManager; } public function getDatabasePlatform() { if ($this->platform === null) { $this->detectDatabasePlatform(); } return $this->platform; } public function getExpressionBuilder() { return $this->_expr; } public function connect() { if ($this->isConnected) { return \false; } $driverOptions = $this->params['driverOptions'] ?? []; $user = $this->params['user'] ?? null; $password = $this->params['password'] ?? null; $this->_conn = $this->_driver->connect($this->params, $user, $password, $driverOptions); $this->isConnected = \true; $this->transactionNestingLevel = 0; if ($this->autoCommit === \false) { $this->beginTransaction(); } if ($this->_eventManager->hasListeners(\MailPoetVendor\Doctrine\DBAL\Events::postConnect)) { $eventArgs = new \MailPoetVendor\Doctrine\DBAL\Event\ConnectionEventArgs($this); $this->_eventManager->dispatchEvent(\MailPoetVendor\Doctrine\DBAL\Events::postConnect, $eventArgs); } return \true; } private function detectDatabasePlatform() { $version = $this->getDatabasePlatformVersion(); if ($version !== null) { \assert($this->_driver instanceof \MailPoetVendor\Doctrine\DBAL\VersionAwarePlatformDriver); $this->platform = $this->_driver->createDatabasePlatformForVersion($version); } else { $this->platform = $this->_driver->getDatabasePlatform(); } $this->platform->setEventManager($this->_eventManager); } private function getDatabasePlatformVersion() { if (!$this->_driver instanceof \MailPoetVendor\Doctrine\DBAL\VersionAwarePlatformDriver) { return null; } if (isset($this->params['serverVersion'])) { return $this->params['serverVersion']; } if ($this->_conn === null) { try { $this->connect(); } catch (\Throwable $originalException) { if (empty($this->params['dbname'])) { throw $originalException; } $databaseName = $this->params['dbname']; $this->params['dbname'] = null; try { $this->connect(); } catch (\Throwable $fallbackException) { $this->params['dbname'] = $databaseName; throw $originalException; } $this->params['dbname'] = $databaseName; $serverVersion = $this->getServerVersion(); $this->close(); return $serverVersion; } } return $this->getServerVersion(); } private function getServerVersion() { if ($this->_conn instanceof \MailPoetVendor\Doctrine\DBAL\Driver\ServerInfoAwareConnection && !$this->_conn->requiresQueryForServerVersion()) { return $this->_conn->getServerVersion(); } return null; } public function isAutoCommit() { return $this->autoCommit === \true; } public function setAutoCommit($autoCommit) { $autoCommit = (bool) $autoCommit; if ($autoCommit === $this->autoCommit) { return; } $this->autoCommit = $autoCommit; if ($this->isConnected !== \true || $this->transactionNestingLevel === 0) { return; } $this->commitAll(); } public function setFetchMode($fetchMode) { $this->defaultFetchMode = $fetchMode; } public function fetchAssoc($statement, array $params = [], array $types = []) { return $this->executeQuery($statement, $params, $types)->fetch(\MailPoetVendor\Doctrine\DBAL\FetchMode::ASSOCIATIVE); } public function fetchArray($statement, array $params = [], array $types = []) { return $this->executeQuery($statement, $params, $types)->fetch(\MailPoetVendor\Doctrine\DBAL\FetchMode::NUMERIC); } public function fetchColumn($statement, array $params = [], $column = 0, array $types = []) { return $this->executeQuery($statement, $params, $types)->fetchColumn($column); } public function isConnected() { return $this->isConnected; } public function isTransactionActive() { return $this->transactionNestingLevel > 0; } private function gatherConditions(array $identifiers) { $columns = []; $values = []; $conditions = []; foreach ($identifiers as $columnName => $value) { if ($value === null) { $conditions[] = $this->getDatabasePlatform()->getIsNullExpression($columnName); continue; } $columns[] = $columnName; $values[] = $value; $conditions[] = $columnName . ' = ?'; } return [$columns, $values, $conditions]; } public function delete($tableExpression, array $identifier, array $types = []) { if (empty($identifier)) { throw \MailPoetVendor\Doctrine\DBAL\Exception\InvalidArgumentException::fromEmptyCriteria(); } [$columns, $values, $conditions] = $this->gatherConditions($identifier); return $this->executeUpdate('DELETE FROM ' . $tableExpression . ' WHERE ' . \implode(' AND ', $conditions), $values, \is_string(\key($types)) ? $this->extractTypeValues($columns, $types) : $types); } public function close() { $this->_conn = null; $this->isConnected = \false; } public function setTransactionIsolation($level) { $this->transactionIsolationLevel = $level; return $this->executeUpdate($this->getDatabasePlatform()->getSetTransactionIsolationSQL($level)); } public function getTransactionIsolation() { if ($this->transactionIsolationLevel === null) { $this->transactionIsolationLevel = $this->getDatabasePlatform()->getDefaultTransactionIsolationLevel(); } return $this->transactionIsolationLevel; } public function update($tableExpression, array $data, array $identifier, array $types = []) { $setColumns = []; $setValues = []; $set = []; foreach ($data as $columnName => $value) { $setColumns[] = $columnName; $setValues[] = $value; $set[] = $columnName . ' = ?'; } [$conditionColumns, $conditionValues, $conditions] = $this->gatherConditions($identifier); $columns = \array_merge($setColumns, $conditionColumns); $values = \array_merge($setValues, $conditionValues); if (\is_string(\key($types))) { $types = $this->extractTypeValues($columns, $types); } $sql = 'UPDATE ' . $tableExpression . ' SET ' . \implode(', ', $set) . ' WHERE ' . \implode(' AND ', $conditions); return $this->executeUpdate($sql, $values, $types); } public function insert($tableExpression, array $data, array $types = []) { if (empty($data)) { return $this->executeUpdate('INSERT INTO ' . $tableExpression . ' () VALUES ()'); } $columns = []; $values = []; $set = []; foreach ($data as $columnName => $value) { $columns[] = $columnName; $values[] = $value; $set[] = '?'; } return $this->executeUpdate('INSERT INTO ' . $tableExpression . ' (' . \implode(', ', $columns) . ')' . ' VALUES (' . \implode(', ', $set) . ')', $values, \is_string(\key($types)) ? $this->extractTypeValues($columns, $types) : $types); } private function extractTypeValues(array $columnList, array $types) { $typeValues = []; foreach ($columnList as $columnIndex => $columnName) { $typeValues[] = $types[$columnName] ?? \MailPoetVendor\Doctrine\DBAL\ParameterType::STRING; } return $typeValues; } public function quoteIdentifier($str) { return $this->getDatabasePlatform()->quoteIdentifier($str); } public function quote($input, $type = null) { $this->connect(); [$value, $bindingType] = $this->getBindingInfo($input, $type); return $this->_conn->quote($value, $bindingType); } public function fetchAll($sql, array $params = [], $types = []) { return $this->executeQuery($sql, $params, $types)->fetchAll(); } public function prepare($statement) { try { $stmt = new \MailPoetVendor\Doctrine\DBAL\Statement($statement, $this); } catch (\Throwable $ex) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::driverExceptionDuringQuery($this->_driver, $ex, $statement); } $stmt->setFetchMode($this->defaultFetchMode); return $stmt; } public function executeQuery($query, array $params = [], $types = [], ?\MailPoetVendor\Doctrine\DBAL\Cache\QueryCacheProfile $qcp = null) { if ($qcp !== null) { return $this->executeCacheQuery($query, $params, $types, $qcp); } $this->connect(); $logger = $this->_config->getSQLLogger(); if ($logger) { $logger->startQuery($query, $params, $types); } try { if ($params) { [$query, $params, $types] = \MailPoetVendor\Doctrine\DBAL\SQLParserUtils::expandListParameters($query, $params, $types); $stmt = $this->_conn->prepare($query); if ($types) { $this->_bindTypedValues($stmt, $params, $types); $stmt->execute(); } else { $stmt->execute($params); } } else { $stmt = $this->_conn->query($query); } } catch (\Throwable $ex) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::driverExceptionDuringQuery($this->_driver, $ex, $query, $this->resolveParams($params, $types)); } $stmt->setFetchMode($this->defaultFetchMode); if ($logger) { $logger->stopQuery(); } return $stmt; } public function executeCacheQuery($query, $params, $types, \MailPoetVendor\Doctrine\DBAL\Cache\QueryCacheProfile $qcp) { $resultCache = $qcp->getResultCacheDriver() ?: $this->_config->getResultCacheImpl(); if (!$resultCache) { throw \MailPoetVendor\Doctrine\DBAL\Cache\CacheException::noResultDriverConfigured(); } [$cacheKey, $realKey] = $qcp->generateCacheKeys($query, $params, $types, $this->getParams()); $data = $resultCache->fetch($cacheKey); if ($data !== \false) { if (isset($data[$realKey])) { $stmt = new \MailPoetVendor\Doctrine\DBAL\Cache\ArrayStatement($data[$realKey]); } elseif (\array_key_exists($realKey, $data)) { $stmt = new \MailPoetVendor\Doctrine\DBAL\Cache\ArrayStatement([]); } } if (!isset($stmt)) { $stmt = new \MailPoetVendor\Doctrine\DBAL\Cache\ResultCacheStatement($this->executeQuery($query, $params, $types), $resultCache, $cacheKey, $realKey, $qcp->getLifetime()); } $stmt->setFetchMode($this->defaultFetchMode); return $stmt; } public function project($query, array $params, \Closure $function) { $result = []; $stmt = $this->executeQuery($query, $params); while ($row = $stmt->fetch()) { $result[] = $function($row); } $stmt->closeCursor(); return $result; } public function query() { $this->connect(); $args = \func_get_args(); $logger = $this->_config->getSQLLogger(); if ($logger) { $logger->startQuery($args[0]); } try { $statement = $this->_conn->query(...$args); } catch (\Throwable $ex) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::driverExceptionDuringQuery($this->_driver, $ex, $args[0]); } $statement->setFetchMode($this->defaultFetchMode); if ($logger) { $logger->stopQuery(); } return $statement; } public function executeUpdate($query, array $params = [], array $types = []) { $this->connect(); $logger = $this->_config->getSQLLogger(); if ($logger) { $logger->startQuery($query, $params, $types); } try { if ($params) { [$query, $params, $types] = \MailPoetVendor\Doctrine\DBAL\SQLParserUtils::expandListParameters($query, $params, $types); $stmt = $this->_conn->prepare($query); if ($types) { $this->_bindTypedValues($stmt, $params, $types); $stmt->execute(); } else { $stmt->execute($params); } $result = $stmt->rowCount(); } else { $result = $this->_conn->exec($query); } } catch (\Throwable $ex) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::driverExceptionDuringQuery($this->_driver, $ex, $query, $this->resolveParams($params, $types)); } if ($logger) { $logger->stopQuery(); } return $result; } public function exec($statement) { $this->connect(); $logger = $this->_config->getSQLLogger(); if ($logger) { $logger->startQuery($statement); } try { $result = $this->_conn->exec($statement); } catch (\Throwable $ex) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::driverExceptionDuringQuery($this->_driver, $ex, $statement); } if ($logger) { $logger->stopQuery(); } return $result; } public function getTransactionNestingLevel() { return $this->transactionNestingLevel; } public function errorCode() { $this->connect(); return $this->_conn->errorCode(); } public function errorInfo() { $this->connect(); return $this->_conn->errorInfo(); } public function lastInsertId($seqName = null) { $this->connect(); return $this->_conn->lastInsertId($seqName); } public function transactional(\Closure $func) { $this->beginTransaction(); try { $res = $func($this); $this->commit(); return $res; } catch (\Exception $e) { $this->rollBack(); throw $e; } catch (\Throwable $e) { $this->rollBack(); throw $e; } } public function setNestTransactionsWithSavepoints($nestTransactionsWithSavepoints) { if ($this->transactionNestingLevel > 0) { throw \MailPoetVendor\Doctrine\DBAL\ConnectionException::mayNotAlterNestedTransactionWithSavepointsInTransaction(); } if (!$this->getDatabasePlatform()->supportsSavepoints()) { throw \MailPoetVendor\Doctrine\DBAL\ConnectionException::savepointsNotSupported(); } $this->nestTransactionsWithSavepoints = (bool) $nestTransactionsWithSavepoints; } public function getNestTransactionsWithSavepoints() { return $this->nestTransactionsWithSavepoints; } protected function _getNestedTransactionSavePointName() { return 'DOCTRINE2_SAVEPOINT_' . $this->transactionNestingLevel; } public function beginTransaction() { $this->connect(); ++$this->transactionNestingLevel; $logger = $this->_config->getSQLLogger(); if ($this->transactionNestingLevel === 1) { if ($logger) { $logger->startQuery('"START TRANSACTION"'); } $this->_conn->beginTransaction(); if ($logger) { $logger->stopQuery(); } } elseif ($this->nestTransactionsWithSavepoints) { if ($logger) { $logger->startQuery('"SAVEPOINT"'); } $this->createSavepoint($this->_getNestedTransactionSavePointName()); if ($logger) { $logger->stopQuery(); } } } public function commit() { if ($this->transactionNestingLevel === 0) { throw \MailPoetVendor\Doctrine\DBAL\ConnectionException::noActiveTransaction(); } if ($this->isRollbackOnly) { throw \MailPoetVendor\Doctrine\DBAL\ConnectionException::commitFailedRollbackOnly(); } $this->connect(); $logger = $this->_config->getSQLLogger(); if ($this->transactionNestingLevel === 1) { if ($logger) { $logger->startQuery('"COMMIT"'); } $this->_conn->commit(); if ($logger) { $logger->stopQuery(); } } elseif ($this->nestTransactionsWithSavepoints) { if ($logger) { $logger->startQuery('"RELEASE SAVEPOINT"'); } $this->releaseSavepoint($this->_getNestedTransactionSavePointName()); if ($logger) { $logger->stopQuery(); } } --$this->transactionNestingLevel; if ($this->autoCommit !== \false || $this->transactionNestingLevel !== 0) { return; } $this->beginTransaction(); } private function commitAll() { while ($this->transactionNestingLevel !== 0) { if ($this->autoCommit === \false && $this->transactionNestingLevel === 1) { $this->commit(); return; } $this->commit(); } } public function rollBack() { if ($this->transactionNestingLevel === 0) { throw \MailPoetVendor\Doctrine\DBAL\ConnectionException::noActiveTransaction(); } $this->connect(); $logger = $this->_config->getSQLLogger(); if ($this->transactionNestingLevel === 1) { if ($logger) { $logger->startQuery('"ROLLBACK"'); } $this->transactionNestingLevel = 0; $this->_conn->rollBack(); $this->isRollbackOnly = \false; if ($logger) { $logger->stopQuery(); } if ($this->autoCommit === \false) { $this->beginTransaction(); } } elseif ($this->nestTransactionsWithSavepoints) { if ($logger) { $logger->startQuery('"ROLLBACK TO SAVEPOINT"'); } $this->rollbackSavepoint($this->_getNestedTransactionSavePointName()); --$this->transactionNestingLevel; if ($logger) { $logger->stopQuery(); } } else { $this->isRollbackOnly = \true; --$this->transactionNestingLevel; } } public function createSavepoint($savepoint) { if (!$this->getDatabasePlatform()->supportsSavepoints()) { throw \MailPoetVendor\Doctrine\DBAL\ConnectionException::savepointsNotSupported(); } $this->_conn->exec($this->platform->createSavePoint($savepoint)); } public function releaseSavepoint($savepoint) { if (!$this->getDatabasePlatform()->supportsSavepoints()) { throw \MailPoetVendor\Doctrine\DBAL\ConnectionException::savepointsNotSupported(); } if (!$this->platform->supportsReleaseSavepoints()) { return; } $this->_conn->exec($this->platform->releaseSavePoint($savepoint)); } public function rollbackSavepoint($savepoint) { if (!$this->getDatabasePlatform()->supportsSavepoints()) { throw \MailPoetVendor\Doctrine\DBAL\ConnectionException::savepointsNotSupported(); } $this->_conn->exec($this->platform->rollbackSavePoint($savepoint)); } public function getWrappedConnection() { $this->connect(); return $this->_conn; } public function getSchemaManager() { if (!$this->_schemaManager) { $this->_schemaManager = $this->_driver->getSchemaManager($this); } return $this->_schemaManager; } public function setRollbackOnly() { if ($this->transactionNestingLevel === 0) { throw \MailPoetVendor\Doctrine\DBAL\ConnectionException::noActiveTransaction(); } $this->isRollbackOnly = \true; } public function isRollbackOnly() { if ($this->transactionNestingLevel === 0) { throw \MailPoetVendor\Doctrine\DBAL\ConnectionException::noActiveTransaction(); } return $this->isRollbackOnly; } public function convertToDatabaseValue($value, $type) { return \MailPoetVendor\Doctrine\DBAL\Types\Type::getType($type)->convertToDatabaseValue($value, $this->getDatabasePlatform()); } public function convertToPHPValue($value, $type) { return \MailPoetVendor\Doctrine\DBAL\Types\Type::getType($type)->convertToPHPValue($value, $this->getDatabasePlatform()); } private function _bindTypedValues($stmt, array $params, array $types) { if (\is_int(\key($params))) { $typeOffset = \array_key_exists(0, $types) ? -1 : 0; $bindIndex = 1; foreach ($params as $value) { $typeIndex = $bindIndex + $typeOffset; if (isset($types[$typeIndex])) { $type = $types[$typeIndex]; [$value, $bindingType] = $this->getBindingInfo($value, $type); $stmt->bindValue($bindIndex, $value, $bindingType); } else { $stmt->bindValue($bindIndex, $value); } ++$bindIndex; } } else { foreach ($params as $name => $value) { if (isset($types[$name])) { $type = $types[$name]; [$value, $bindingType] = $this->getBindingInfo($value, $type); $stmt->bindValue($name, $value, $bindingType); } else { $stmt->bindValue($name, $value); } } } } private function getBindingInfo($value, $type) { if (\is_string($type)) { $type = \MailPoetVendor\Doctrine\DBAL\Types\Type::getType($type); } if ($type instanceof \MailPoetVendor\Doctrine\DBAL\Types\Type) { $value = $type->convertToDatabaseValue($value, $this->getDatabasePlatform()); $bindingType = $type->getBindingType(); } else { $bindingType = $type; } return [$value, $bindingType]; } public function resolveParams(array $params, array $types) { $resolvedParams = []; if (\is_int(\key($params))) { $typeOffset = \array_key_exists(0, $types) ? -1 : 0; $bindIndex = 1; foreach ($params as $value) { $typeIndex = $bindIndex + $typeOffset; if (isset($types[$typeIndex])) { $type = $types[$typeIndex]; [$value] = $this->getBindingInfo($value, $type); $resolvedParams[$bindIndex] = $value; } else { $resolvedParams[$bindIndex] = $value; } ++$bindIndex; } } else { foreach ($params as $name => $value) { if (isset($types[$name])) { $type = $types[$name]; [$value] = $this->getBindingInfo($value, $type); $resolvedParams[$name] = $value; } else { $resolvedParams[$name] = $value; } } } return $resolvedParams; } public function createQueryBuilder() { return new \MailPoetVendor\Doctrine\DBAL\Query\QueryBuilder($this); } public function ping() { $this->connect(); if ($this->_conn instanceof \MailPoetVendor\Doctrine\DBAL\Driver\PingableConnection) { return $this->_conn->ping(); } try { $this->query($this->getDatabasePlatform()->getDummySelectSQL()); return \true; } catch (\MailPoetVendor\Doctrine\DBAL\DBALException $e) { return \false; } } } 