<?php
 namespace MailPoetVendor\Doctrine\DBAL\Driver; if (!defined('ABSPATH')) exit; use MailPoetVendor\Doctrine\DBAL\Connection; use MailPoetVendor\Doctrine\DBAL\DBALException; use MailPoetVendor\Doctrine\DBAL\Driver; use MailPoetVendor\Doctrine\DBAL\Exception; use MailPoetVendor\Doctrine\DBAL\Platforms\MariaDb1027Platform; use MailPoetVendor\Doctrine\DBAL\Platforms\MySQL57Platform; use MailPoetVendor\Doctrine\DBAL\Platforms\MySQL80Platform; use MailPoetVendor\Doctrine\DBAL\Platforms\MySqlPlatform; use MailPoetVendor\Doctrine\DBAL\Schema\MySqlSchemaManager; use MailPoetVendor\Doctrine\DBAL\VersionAwarePlatformDriver; use function preg_match; use function stripos; use function version_compare; abstract class AbstractMySQLDriver implements \MailPoetVendor\Doctrine\DBAL\Driver, \MailPoetVendor\Doctrine\DBAL\Driver\ExceptionConverterDriver, \MailPoetVendor\Doctrine\DBAL\VersionAwarePlatformDriver { public function convertException($message, \MailPoetVendor\Doctrine\DBAL\Driver\DriverException $exception) { switch ($exception->getErrorCode()) { case '1213': return new \MailPoetVendor\Doctrine\DBAL\Exception\DeadlockException($message, $exception); case '1205': return new \MailPoetVendor\Doctrine\DBAL\Exception\LockWaitTimeoutException($message, $exception); case '1050': return new \MailPoetVendor\Doctrine\DBAL\Exception\TableExistsException($message, $exception); case '1051': case '1146': return new \MailPoetVendor\Doctrine\DBAL\Exception\TableNotFoundException($message, $exception); case '1216': case '1217': case '1451': case '1452': case '1701': return new \MailPoetVendor\Doctrine\DBAL\Exception\ForeignKeyConstraintViolationException($message, $exception); case '1062': case '1557': case '1569': case '1586': return new \MailPoetVendor\Doctrine\DBAL\Exception\UniqueConstraintViolationException($message, $exception); case '1054': case '1166': case '1611': return new \MailPoetVendor\Doctrine\DBAL\Exception\InvalidFieldNameException($message, $exception); case '1052': case '1060': case '1110': return new \MailPoetVendor\Doctrine\DBAL\Exception\NonUniqueFieldNameException($message, $exception); case '1064': case '1149': case '1287': case '1341': case '1342': case '1343': case '1344': case '1382': case '1479': case '1541': case '1554': case '1626': return new \MailPoetVendor\Doctrine\DBAL\Exception\SyntaxErrorException($message, $exception); case '1044': case '1045': case '1046': case '1049': case '1095': case '1142': case '1143': case '1227': case '1370': case '1429': case '2002': case '2005': return new \MailPoetVendor\Doctrine\DBAL\Exception\ConnectionException($message, $exception); case '1048': case '1121': case '1138': case '1171': case '1252': case '1263': case '1364': case '1566': return new \MailPoetVendor\Doctrine\DBAL\Exception\NotNullConstraintViolationException($message, $exception); } return new \MailPoetVendor\Doctrine\DBAL\Exception\DriverException($message, $exception); } public function createDatabasePlatformForVersion($version) { $mariadb = \stripos($version, 'mariadb') !== \false; if ($mariadb && \version_compare($this->getMariaDbMysqlVersionNumber($version), '10.2.7', '>=')) { return new \MailPoetVendor\Doctrine\DBAL\Platforms\MariaDb1027Platform(); } if (!$mariadb) { $oracleMysqlVersion = $this->getOracleMysqlVersionNumber($version); if (\version_compare($oracleMysqlVersion, '8', '>=')) { return new \MailPoetVendor\Doctrine\DBAL\Platforms\MySQL80Platform(); } if (\version_compare($oracleMysqlVersion, '5.7.9', '>=')) { return new \MailPoetVendor\Doctrine\DBAL\Platforms\MySQL57Platform(); } } return $this->getDatabasePlatform(); } private function getOracleMysqlVersionNumber(string $versionString) : string { if (!\preg_match('/^(?P<major>\\d+)(?:\\.(?P<minor>\\d+)(?:\\.(?P<patch>\\d+))?)?/', $versionString, $versionParts)) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::invalidPlatformVersionSpecified($versionString, '<major_version>.<minor_version>.<patch_version>'); } $majorVersion = $versionParts['major']; $minorVersion = $versionParts['minor'] ?? 0; $patchVersion = $versionParts['patch'] ?? null; if ($majorVersion === '5' && $minorVersion === '7' && $patchVersion === null) { $patchVersion = '9'; } return $majorVersion . '.' . $minorVersion . '.' . $patchVersion; } private function getMariaDbMysqlVersionNumber(string $versionString) : string { if (!\preg_match('/^(?:5\\.5\\.5-)?(mariadb-)?(?P<major>\\d+)\\.(?P<minor>\\d+)\\.(?P<patch>\\d+)/i', $versionString, $versionParts)) { throw \MailPoetVendor\Doctrine\DBAL\DBALException::invalidPlatformVersionSpecified($versionString, '^(?:5\\.5\\.5-)?(mariadb-)?<major_version>.<minor_version>.<patch_version>'); } return $versionParts['major'] . '.' . $versionParts['minor'] . '.' . $versionParts['patch']; } public function getDatabase(\MailPoetVendor\Doctrine\DBAL\Connection $conn) { $params = $conn->getParams(); return $params['dbname'] ?? $conn->query('SELECT DATABASE()')->fetchColumn(); } public function getDatabasePlatform() { return new \MailPoetVendor\Doctrine\DBAL\Platforms\MySqlPlatform(); } public function getSchemaManager(\MailPoetVendor\Doctrine\DBAL\Connection $conn) { return new \MailPoetVendor\Doctrine\DBAL\Schema\MySqlSchemaManager($conn); } } 