<?php
 namespace MailPoetVendor\Doctrine\ORM\Tools\Pagination; if (!defined('ABSPATH')) exit; use MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata; use MailPoetVendor\Doctrine\ORM\Query\AST\ArithmeticExpression; use MailPoetVendor\Doctrine\ORM\Query\AST\ConditionalExpression; use MailPoetVendor\Doctrine\ORM\Query\AST\ConditionalFactor; use MailPoetVendor\Doctrine\ORM\Query\AST\ConditionalPrimary; use MailPoetVendor\Doctrine\ORM\Query\AST\ConditionalTerm; use MailPoetVendor\Doctrine\ORM\Query\AST\InExpression; use MailPoetVendor\Doctrine\ORM\Query\AST\InputParameter; use MailPoetVendor\Doctrine\ORM\Query\AST\NullComparisonExpression; use MailPoetVendor\Doctrine\ORM\Query\AST\PathExpression; use MailPoetVendor\Doctrine\ORM\Query\AST\SelectStatement; use MailPoetVendor\Doctrine\ORM\Query\AST\SimpleArithmeticExpression; use MailPoetVendor\Doctrine\ORM\Query\AST\WhereClause; use MailPoetVendor\Doctrine\ORM\Query\TreeWalkerAdapter; use MailPoetVendor\Doctrine\ORM\Utility\PersisterHelper; use function array_map; use function assert; use function is_array; class WhereInWalker extends \MailPoetVendor\Doctrine\ORM\Query\TreeWalkerAdapter { const HINT_PAGINATOR_ID_COUNT = 'doctrine.id.count'; const PAGINATOR_ID_ALIAS = 'dpid'; public function walkSelectStatement(\MailPoetVendor\Doctrine\ORM\Query\AST\SelectStatement $AST) { $queryComponents = $this->_getQueryComponents(); $from = $AST->fromClause->identificationVariableDeclarations; if (\count($from) > 1) { throw new \RuntimeException("Cannot count query which selects two FROM components, cannot make distinction"); } $fromRoot = \reset($from); $rootAlias = $fromRoot->rangeVariableDeclaration->aliasIdentificationVariable; $rootClass = $queryComponents[$rootAlias]['metadata']; $identifierFieldName = $rootClass->getSingleIdentifierFieldName(); $pathType = \MailPoetVendor\Doctrine\ORM\Query\AST\PathExpression::TYPE_STATE_FIELD; if (isset($rootClass->associationMappings[$identifierFieldName])) { $pathType = \MailPoetVendor\Doctrine\ORM\Query\AST\PathExpression::TYPE_SINGLE_VALUED_ASSOCIATION; } $pathExpression = new \MailPoetVendor\Doctrine\ORM\Query\AST\PathExpression(\MailPoetVendor\Doctrine\ORM\Query\AST\PathExpression::TYPE_STATE_FIELD | \MailPoetVendor\Doctrine\ORM\Query\AST\PathExpression::TYPE_SINGLE_VALUED_ASSOCIATION, $rootAlias, $identifierFieldName); $pathExpression->type = $pathType; $count = $this->_getQuery()->getHint(self::HINT_PAGINATOR_ID_COUNT); if ($count > 0) { $arithmeticExpression = new \MailPoetVendor\Doctrine\ORM\Query\AST\ArithmeticExpression(); $arithmeticExpression->simpleArithmeticExpression = new \MailPoetVendor\Doctrine\ORM\Query\AST\SimpleArithmeticExpression([$pathExpression]); $expression = new \MailPoetVendor\Doctrine\ORM\Query\AST\InExpression($arithmeticExpression); $expression->literals[] = new \MailPoetVendor\Doctrine\ORM\Query\AST\InputParameter(":" . self::PAGINATOR_ID_ALIAS); $this->convertWhereInIdentifiersToDatabaseValue(\MailPoetVendor\Doctrine\ORM\Utility\PersisterHelper::getTypeOfField($identifierFieldName, $rootClass, $this->_getQuery()->getEntityManager())[0]); } else { $expression = new \MailPoetVendor\Doctrine\ORM\Query\AST\NullComparisonExpression($pathExpression); $expression->not = \false; } $conditionalPrimary = new \MailPoetVendor\Doctrine\ORM\Query\AST\ConditionalPrimary(); $conditionalPrimary->simpleConditionalExpression = $expression; if ($AST->whereClause) { if ($AST->whereClause->conditionalExpression instanceof \MailPoetVendor\Doctrine\ORM\Query\AST\ConditionalTerm) { $AST->whereClause->conditionalExpression->conditionalFactors[] = $conditionalPrimary; } elseif ($AST->whereClause->conditionalExpression instanceof \MailPoetVendor\Doctrine\ORM\Query\AST\ConditionalPrimary) { $AST->whereClause->conditionalExpression = new \MailPoetVendor\Doctrine\ORM\Query\AST\ConditionalExpression([new \MailPoetVendor\Doctrine\ORM\Query\AST\ConditionalTerm([$AST->whereClause->conditionalExpression, $conditionalPrimary])]); } elseif ($AST->whereClause->conditionalExpression instanceof \MailPoetVendor\Doctrine\ORM\Query\AST\ConditionalExpression || $AST->whereClause->conditionalExpression instanceof \MailPoetVendor\Doctrine\ORM\Query\AST\ConditionalFactor) { $tmpPrimary = new \MailPoetVendor\Doctrine\ORM\Query\AST\ConditionalPrimary(); $tmpPrimary->conditionalExpression = $AST->whereClause->conditionalExpression; $AST->whereClause->conditionalExpression = new \MailPoetVendor\Doctrine\ORM\Query\AST\ConditionalTerm([$tmpPrimary, $conditionalPrimary]); } } else { $AST->whereClause = new \MailPoetVendor\Doctrine\ORM\Query\AST\WhereClause(new \MailPoetVendor\Doctrine\ORM\Query\AST\ConditionalExpression([new \MailPoetVendor\Doctrine\ORM\Query\AST\ConditionalTerm([$conditionalPrimary])])); } } private function convertWhereInIdentifiersToDatabaseValue(string $type) : void { $query = $this->_getQuery(); $identifiersParameter = $query->getParameter(self::PAGINATOR_ID_ALIAS); \assert($identifiersParameter !== null); $identifiers = $identifiersParameter->getValue(); \assert(\is_array($identifiers)); $connection = $this->_getQuery()->getEntityManager()->getConnection(); $query->setParameter(self::PAGINATOR_ID_ALIAS, \array_map(static function ($id) use($connection, $type) { return $connection->convertToDatabaseValue($id, $type); }, $identifiers)); } } 