<?php
 namespace MailPoetVendor\Doctrine\ORM\Query\Exec; if (!defined('ABSPATH')) exit; use MailPoetVendor\Doctrine\DBAL\Connection; use MailPoetVendor\Doctrine\DBAL\Types\Type; use MailPoetVendor\Doctrine\ORM\Query\AST; use MailPoetVendor\Doctrine\ORM\Query\AST\DeleteStatement; use MailPoetVendor\Doctrine\ORM\Query\SqlWalker; use MailPoetVendor\Doctrine\ORM\Utility\PersisterHelper; use Throwable; class MultiTableDeleteExecutor extends \MailPoetVendor\Doctrine\ORM\Query\Exec\AbstractSqlExecutor { private $_createTempTableSql; private $_dropTempTableSql; private $_insertSql; public function __construct(\MailPoetVendor\Doctrine\ORM\Query\AST\Node $AST, $sqlWalker) { $em = $sqlWalker->getEntityManager(); $conn = $em->getConnection(); $platform = $conn->getDatabasePlatform(); $quoteStrategy = $em->getConfiguration()->getQuoteStrategy(); $primaryClass = $em->getClassMetadata($AST->deleteClause->abstractSchemaName); $primaryDqlAlias = $AST->deleteClause->aliasIdentificationVariable; $rootClass = $em->getClassMetadata($primaryClass->rootEntityName); $tempTable = $platform->getTemporaryTableName($rootClass->getTemporaryIdTableName()); $idColumnNames = $rootClass->getIdentifierColumnNames(); $idColumnList = \implode(', ', $idColumnNames); $sqlWalker->setSQLTableAlias($primaryClass->getTableName(), 't0', $primaryDqlAlias); $this->_insertSql = 'INSERT INTO ' . $tempTable . ' (' . $idColumnList . ')' . ' SELECT t0.' . \implode(', t0.', $idColumnNames); $rangeDecl = new \MailPoetVendor\Doctrine\ORM\Query\AST\RangeVariableDeclaration($primaryClass->name, $primaryDqlAlias); $fromClause = new \MailPoetVendor\Doctrine\ORM\Query\AST\FromClause([new \MailPoetVendor\Doctrine\ORM\Query\AST\IdentificationVariableDeclaration($rangeDecl, null, [])]); $this->_insertSql .= $sqlWalker->walkFromClause($fromClause); if ($AST->whereClause) { $this->_insertSql .= $sqlWalker->walkWhereClause($AST->whereClause); } $idSubselect = 'SELECT ' . $idColumnList . ' FROM ' . $tempTable; $classNames = \array_merge($primaryClass->parentClasses, [$primaryClass->name], $primaryClass->subClasses); foreach (\array_reverse($classNames) as $className) { $tableName = $quoteStrategy->getTableName($em->getClassMetadata($className), $platform); $this->_sqlStatements[] = 'DELETE FROM ' . $tableName . ' WHERE (' . $idColumnList . ') IN (' . $idSubselect . ')'; } $columnDefinitions = []; foreach ($idColumnNames as $idColumnName) { $columnDefinitions[$idColumnName] = ['notnull' => \true, 'type' => \MailPoetVendor\Doctrine\DBAL\Types\Type::getType(\MailPoetVendor\Doctrine\ORM\Utility\PersisterHelper::getTypeOfColumn($idColumnName, $rootClass, $em))]; } $this->_createTempTableSql = $platform->getCreateTemporaryTableSnippetSQL() . ' ' . $tempTable . ' (' . $platform->getColumnDeclarationListSQL($columnDefinitions) . ')'; $this->_dropTempTableSql = $platform->getDropTemporaryTableSQL($tempTable); } public function execute(\MailPoetVendor\Doctrine\DBAL\Connection $conn, array $params, array $types) { $conn->executeUpdate($this->_createTempTableSql); try { $numDeleted = $conn->executeUpdate($this->_insertSql, $params, $types); foreach ($this->_sqlStatements as $sql) { $conn->executeUpdate($sql); } } catch (\Throwable $exception) { $conn->executeUpdate($this->_dropTempTableSql); throw $exception; } $conn->executeUpdate($this->_dropTempTableSql); return $numDeleted; } } 