<?php
 namespace MailPoetVendor; if (!defined('ABSPATH')) exit; class Swift_Plugins_LoggerPlugin implements \MailPoetVendor\Swift_Events_CommandListener, \MailPoetVendor\Swift_Events_ResponseListener, \MailPoetVendor\Swift_Events_TransportChangeListener, \MailPoetVendor\Swift_Events_TransportExceptionListener, \MailPoetVendor\Swift_Plugins_Logger { private $logger; public function __construct(\MailPoetVendor\Swift_Plugins_Logger $logger) { $this->logger = $logger; } public function add($entry) { $this->logger->add($entry); } public function clear() { $this->logger->clear(); } public function dump() { return $this->logger->dump(); } public function commandSent(\MailPoetVendor\Swift_Events_CommandEvent $evt) { $command = $evt->getCommand(); $this->logger->add(\sprintf('>> %s', $command)); } public function responseReceived(\MailPoetVendor\Swift_Events_ResponseEvent $evt) { $response = $evt->getResponse(); $this->logger->add(\sprintf('<< %s', $response)); } public function beforeTransportStarted(\MailPoetVendor\Swift_Events_TransportChangeEvent $evt) { $transportName = \get_class($evt->getSource()); $this->logger->add(\sprintf('++ Starting %s', $transportName)); } public function transportStarted(\MailPoetVendor\Swift_Events_TransportChangeEvent $evt) { $transportName = \get_class($evt->getSource()); $this->logger->add(\sprintf('++ %s started', $transportName)); } public function beforeTransportStopped(\MailPoetVendor\Swift_Events_TransportChangeEvent $evt) { $transportName = \get_class($evt->getSource()); $this->logger->add(\sprintf('++ Stopping %s', $transportName)); } public function transportStopped(\MailPoetVendor\Swift_Events_TransportChangeEvent $evt) { $transportName = \get_class($evt->getSource()); $this->logger->add(\sprintf('++ %s stopped', $transportName)); } public function exceptionThrown(\MailPoetVendor\Swift_Events_TransportExceptionEvent $evt) { $e = $evt->getException(); $message = $e->getMessage(); $code = $e->getCode(); $this->logger->add(\sprintf('!! %s (code: %s)', $message, $code)); $message .= \PHP_EOL; $message .= 'Log data:' . \PHP_EOL; $message .= $this->logger->dump(); $evt->cancelBubble(); throw new \MailPoetVendor\Swift_TransportException($message, $code, $e->getPrevious()); } } 