<?php

/**
 * Swedish Greys Shortcodes
 *
 * This file contains all the definitions for the default Swedish Greys shortcodes.
 *
 * @package Swedish Greys
 * @subpackage Shortcodes
 */


add_shortcode( 'title', 'ntp_entry_title' );
add_shortcode( 'author', 'ntp_entry_author' );
add_shortcode( 'categories', 'ntp_entry_categories' );
add_shortcode( 'comments', 'ntp_entry_comments' );
add_shortcode( 'date', 'ntp_entry_date' );
add_shortcode( 'tags', 'ntp_entry_tags' );
add_shortcode( 'time', 'ntp_entry_time' );
add_shortcode( 'edit', 'ntp_entry_edit' );
add_shortcode( 'more', 'ntp_readmore' );


/**
 * Enable Shortcodes in widget areas
 *
 * @since Swedish Greys 0.9.9
 */

add_filter( 'widget_text', 'shortcode_unautop');
add_filter( 'widget_text', 'do_shortcode');



/**
 * Displays the current post title.
 *
 * @since Swedish Greys 0.9.9
 *
 */
function ntp_entry_title() {
	return get_the_title();
}


/**
 * Displays the current post author.
 * Formatted for hAtom microformat.
 *
 * @since Swedish Greys 0.9.9
 *
 */
function ntp_entry_author() {
	
	$output = '<span class="vcard author entry-author">';
	$output .= '<a href="' . get_author_posts_url( get_the_author_meta('ID') ) . '" class="url fn" title="' . sprintf( __('View all posts by %s', 'ntp_framework'), esc_attr( get_the_author() ) ) .'">';
	$output .= get_the_author();
	$output .= '</a>';
	$output .= '</span>';
	
	return $output;
}


/**
 * Displays the current post date, if time since is installed, it will use that instead.
 * Formatted for hAtom microformat.
 *
 * @since Swedish Greys 0.9.9
 *
 * @uses ntp_time_since
 *
 */
function ntp_entry_date( $atts ) {
	extract ( shortcode_atts ( array (
		'format' => get_option('date_format')
	), $atts ) );
	if ( is_home() ) :
		return '<span class="published entry-date"><a href="' . get_permalink() . '">' . get_the_time( $format ) . '</a></span>';
	else :
		return '<span class="published entry-date">' . get_the_time( $format ) . '</span>';
	endif;
}

/**
 * Displays the current post time
 *
 * @since Swedish Greys 0.9.9
 */
function ntp_entry_time() {
	return '<span class="entry-time">' . get_the_time( get_option('time_format') ) . '</span>';
}

/**
 * Displays the current post categories
 *
 * @since Swedish Greys 0.9.9
 *
 * @uses get_the_category_list
 *
 */
function ntp_entry_categories() {
	return '<span class="entry-categories">' . get_the_category_list(', ') . '</span>';
}


/**
 * Displays the current post tags or blank if none.
 *
 * @since Swedish Greys 0.9.9
 *
 */
function ntp_entry_tags() {
	if ( $tags = get_the_tag_list( '<span>' . __('Tagged: ','ntp_framework') . '</span>', ', ' ) )
		return '<span class="entry-tags">' . $tags . '</span>';
}


/**
 * Displays the number of comments in current post as a link to the comments, wrapped in a <span>.
 *
 * @since Swedish Greys 0.9.9
 *
 */
function ntp_entry_comments() {
	ob_start();
	comments_popup_link(apply_filters('ntp_leave_comment_text', __('Leave a comment', 'ntp_framework')), apply_filters('ntp_single_comment_text', __('1 Comment', 'ntp_framework')), apply_filters('ntp_multiple_comment_text', __('% Comments', 'ntp_framework')));
	return '<span class="entry-comments">' . ob_get_clean() . '</span>';
}


/**
 * Displays an Edit link for admins
 *
 * @since Swedish Greys 0.9.9
 */
function ntp_entry_edit() {
	if ( current_user_can('edit_posts') )
		return '<span class="meta-sep">|</span> <span class="edit-link"><a href="' . get_edit_post_link() . '">' . __('Edit', 'ntp_framework') . '</a></span>';
}


/**
 * Displays a Read More link
 *
 * @since Swedish Greys 0.9.9
 *
 * @uses get_permalink
 *
 */
function ntp_readmore() {
	return '<a href="' . get_permalink() . '" title="' . sprintf(__('Continue Reading %s', 'ntp_framework'), esc_html(get_the_title(), 1)) . '" rel="nofollow" class="more-link">' . apply_filters( 'ntp_read_more', 'Continue reading <span class="meta-nav">&raquo;</span>', 'ntp_framework' ) . '</a>';
}
?>