<?php
/**
 * Loop Attachment Template
 *
 *
 * @package Swedish Greys
 * @subpackage Template
 */
?>

<?php if (have_posts()) : while (have_posts()) : the_post(); ?>

                                <h1 class="page-title"><a href="<?php echo get_permalink($post->post_parent) ?>" title="<?php printf( __( 'Return to %s', 'ntp_framework' ), esc_html( get_the_title($post->post_parent), 1 ) ) ?>" rev="attachment"><span class="meta-nav">&laquo; </span><?php echo get_the_title($post->post_parent) ?></a></h1>

									<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
										<h2 class="entry-title"><?php the_title(); ?></h2>
										
										<div class="entry-meta">
                                                <span class="meta-prep meta-prep-author"><?php _e('By ', 'ntp_framework'); ?></span>
                                                <span class="author vcard"><a class="url fn n" href="<?php echo get_author_posts_url( false, $authordata->ID, $authordata->user_nicename ); ?>" title="<?php printf( __( 'View all posts by %s', 'your-theme' ), $authordata->display_name ); ?>"><?php the_author(); ?></a></span>
                                                <span class="meta-sep"> | </span>
                                                <span class="meta-prep meta-prep-entry-date"><?php _e('Published ', 'ntp_framework'); ?></span>
                                                <span class="entry-date"><abbr class="published" title="<?php the_time('Y-m-d\TH:i:sO') ?>"><?php the_time( get_option( 'date_format' ) ); ?></abbr></span>
                                                <?php edit_post_link( __( 'Edit', 'ntp_framework' ), "<span class=\"meta-sep\">|</span>\n\t\t\t\t\t\t<span class=\"edit-link\">", "</span>\n\t\t\t\t\t" ) ?>                                               
                                        </div><!-- .entry-meta -->
                                        
										<div class="entry-content">
											<div class="entry-attachment">
												<?php echo wp_get_attachment_image( $post->ID, $size='large', false); ?>
											</div>
											
											<div class="entry-caption"><?php if ( !empty($post->post_excerpt) ) the_excerpt() ?></div>
 
											<?php the_content( __( 'Continue reading <span class="meta-nav">&raquo;</span>', 'ntp_framework' )  ); ?>
											<?php wp_link_pages('before=<div class="page-link">' . __( 'Pages:', 'ntp_framework' ) . '&after=</div>') ?>
											
										</div><!-- .entry-content -->
    								                                                                                                   
                                	</div><!-- #post-<?php the_ID(); ?> -->
    	
    								<?php comments_template('', true); ?>

    <?php endwhile; ?>

<?php else : ?>
<?php endif; ?>